; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		XRF_MAP_SELECTOR
;
;LAST CHANGED: ----------------------------------- 	21-Jun-10
;
; PURPOSE:
;	This function and associated procedures is a widget which
;  displays XRF maps read from APS-XRF files and allows selection of 1 or more
;  maps for transfer to aXis2000
;
; CATEGORY:
;	Image display.and map selection
;
; CALLING SEQUENCE:
;	xrf_map_selector, map_list=map_list
;
; INPUTS:
; This section is for POSITIONAL INPUTS only (not keywords)
;	All input parameters are passed via common.
;
; KEYWORDS:
;
;
; OUTPUTS:
;	No explicit outputs.   A new window is created if necessary
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;	XRF_COM  - parameters specific to XRF_MAP_SELECTOR and user files
;
; SIDE EFFECTS:
;	A window is created/destroyed.
;
; PROCEDURE:
;	details where needed
;
; EXAMPLE:

;
; MODIFICATION HISTORY:
; (21-Jun-10 aph) first version
;-


pro BUT_XRF_CANCEL, Event
@axis_com
@xrf_com

on_error,2
xrf_maps = 0
WIDGET_CONTROL, Event.Top, /DESTROY
end

; -------------------------------------------
pro BUT_XRF_OK, Event
@axis_com
@xrf_com

on_error,2
xrf_maps = intarr(9)
; ---------- read state of each drop list
id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_1')
xrf_maps(0)= WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_2')
xrf_maps(1) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_3')
xrf_maps(2) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_4')
xrf_maps(3) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_5')
xrf_maps(4) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_6')
xrf_maps(5) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_7')
xrf_maps(6) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_8')
xrf_maps(7) = WIDGET_INFO(id, /droplist_select)

id = widget_info(Event.top, FIND_BY_UNAME = 'XRF_map_droplist_9')
xrf_maps(8) = WIDGET_INFO(id, /droplist_select)

; print, xrf_maps

; for i = 0,8 do print, xrf_map_list(xrf_maps(i))

WIDGET_CONTROL, Event.Top, /DESTROY
end


;-----------------------------------------------------------------
; ****************************************************************
;-----------------------------------------------------------------

pro BASE_APS_XRF_event, Event
@axis_com
@xrf_com


  wTarget = (widget_info(Event.id,/NAME) eq 'TREE' ?  $
      widget_info(Event.id, /tree_root) : event.id)
  wWidget =  Event.top

  case wTarget of

    Widget_Info(wWidget, FIND_BY_UNAME='BUT_XRF_OK'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_XRF_OK, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_XRF_CANCEL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_XRF_CANCEL, Event
    end

  else:
  endcase

end

;-----------------------------------------------------------------
; ****************************************************************
;-----------------------------------------------------------------

pro BASE_APS_XRF, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@xrf_com

t = size(wGroup)
IF t(1) EQ 0 THEN modal_val=0 else modal_val=1

;  Resolve_Routine, 'xrf_map_SELECTOR_eventcb',/COMPILE_FULL_FILE  ; Load event callback routines

  BASE_APS_XRF = Widget_Base( GROUP_LEADER=wGroup, UNAME='BASE_APS_XRF'  $
      ,XOFFSET=5 ,YOFFSET=1 ,SCR_XSIZE=260 ,SCR_YSIZE=310  $
      ,TITLE='XRF map selector' ,SPACE=3 ,XPAD=3 ,YPAD=3, modal = modal_val)

   tlabel = widget_label(BASE_APS_XRF, XOFFSET=0 ,YOFFSET=3, value='Buffer    Map' )
  offset = 15
  increment = 25
  tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset, value='1' )
  XRF_map_droplist_1 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_1'  $
     ,XOFFSET=30 ,YOFFSET=offset,SCR_XSIZE=200 ,SCR_YSIZE=22)
 tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + increment, value='2' )
  XRF_map_droplist_2 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_2'  $
     ,XOFFSET=30 ,YOFFSET=offset + increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 2*increment, value='3' )
  XRF_map_droplist_3 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_3'  $
     ,XOFFSET=30 ,YOFFSET=offset + 2*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 3*increment, value='4' )
  XRF_map_droplist_4 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_4'  $
     ,XOFFSET=30 ,YOFFSET=offset + 3*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 4*increment, value='5' )
  XRF_map_droplist_5 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_5'  $
     ,XOFFSET=30 ,YOFFSET=offset + 4*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 5*increment, value='6' )
  XRF_map_droplist_6 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_6'  $
     ,XOFFSET=30 ,YOFFSET=offset + 5*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 6*increment, value='7' )
  XRF_map_droplist_7 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_7'  $
     ,XOFFSET=30 ,YOFFSET=offset + 6*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

 tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 7*increment, value='8' )
  XRF_map_droplist_8 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_8'  $
     ,XOFFSET=30 ,YOFFSET=offset + 7*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

tlabel = widget_label(BASE_APS_XRF, XOFFSET=10 ,YOFFSET=3+offset + 8*increment, value='9' )
  XRF_map_droplist_9 = Widget_Droplist(BASE_APS_XRF, UNAME='XRF_map_droplist_9'  $
     ,XOFFSET=30 ,YOFFSET=offset + 8*increment ,SCR_XSIZE=200 ,SCR_YSIZE=22)

;  DRAW_XRF_MAP = Widget_Draw(BASE_APS_XRF, UNAME='XRF_map' ,XOFFSET=30  $
;      ,YOFFSET=80 ,SCR_XSIZE=200 ,SCR_YSIZE=200)
offset = offset + 10
  BUT_XRF_CANCEL = Widget_Button(BASE_APS_XRF, UNAME='BUT_XRF_CANCEL'  $
      ,XOFFSET=30 ,YOFFSET=offset + 9*increment ,SCR_XSIZE=80 ,SCR_YSIZE=30  $
      ,/ALIGN_CENTER ,VALUE='Cancel')

  BUT_XRF_OK = Widget_Button(BASE_APS_XRF, UNAME='BUT_XRF_OK'  $
      ,XOFFSET=150,YOFFSET=offset + 9*increment ,SCR_XSIZE=80 ,SCR_YSIZE=30  $
      ,/ALIGN_CENTER ,VALUE='OK')

;  ------------- load map information into pull down list
;	labels = strarr(3)
;	labels(0)='map 1'
;	labels(1)='map 2'
;	labels(2)='map 3'
;	b= fltarr(3,50,50)
;	b(0,*,*) = dist(50)
;	b(1,*,*) = 200.
;	b(2,*,*) = dist(50)
;	xrf={labels: labels, maps: b}

;	n_maps = n_elements(xrf.labels)
;	xrf_map_list = strarr(n_maps)
;	for i = 0, n_maps(0)-1 do xrf_map_list(i) = xrf.labels[i]

; ----- extend xrf_map_list
nr = n_elements(xrf_map_list)
xrf_map_list = [xrf_map_list, ' ']
for i = nr, 1, -1 do xrf_map_list(i) = xrf_map_list(i-1)
xrf_map_list(0) = ' '
if nr LT 9 then for i = nr+1, 9 do xrf_map_list = [xrf_map_list, ' ']

WIDGET_CONTROL,XRF_map_droplist_1, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_2, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_3, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_4, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_5, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_6, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_7, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_8, Set_VALUE = xrf_map_list, sensitive = 1
WIDGET_CONTROL,XRF_map_droplist_9, Set_VALUE = xrf_map_list, sensitive = 1

if n_elements(xrf_maps) EQ 0 then xrf_maps = indgen(9)

WIDGET_CONTROL, XRF_map_droplist_1, SET_DROPLIST_SELECT = xrf_maps(0)
WIDGET_CONTROL, XRF_map_droplist_2, SET_DROPLIST_SELECT = xrf_maps(1)
WIDGET_CONTROL, XRF_map_droplist_3, SET_DROPLIST_SELECT = xrf_maps(2)
WIDGET_CONTROL, XRF_map_droplist_4, SET_DROPLIST_SELECT = xrf_maps(3)
WIDGET_CONTROL, XRF_map_droplist_5, SET_DROPLIST_SELECT = xrf_maps(4)
WIDGET_CONTROL, XRF_map_droplist_6, SET_DROPLIST_SELECT = xrf_maps(5)
WIDGET_CONTROL, XRF_map_droplist_7, SET_DROPLIST_SELECT = xrf_maps(6)
WIDGET_CONTROL, XRF_map_droplist_8, SET_DROPLIST_SELECT = xrf_maps(7)
WIDGET_CONTROL, XRF_map_droplist_9, SET_DROPLIST_SELECT = xrf_maps(8)

; --- load 1st map
; WIDGET_CONTROL, DRAW_XRF_MAP, GET_VALUE=XRF_map_ID
;	WSET, XRF_map_ID
;	t=size(b)
;	map_img=intarr(t(1),t(2))
;	map_img = b(0,*,*)
;	tvscl, map_img

  Widget_Control, /REALIZE, BASE_APS_XRF

  XManager, 'BASE_APS_XRF', BASE_APS_XRF, /NO_BLOCK
   XRF_MAP_ID = BASE_APS_XRF		; store in Common for use for any routines needing group call

end

;-----------------------------------------------------------------
; ****************************************************************
;-----------------------------------------------------------------


function xrf_map_selector, list=list, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@xrf_com

if n_elements(xrf_maps) LE 1 then xrf_maps = intarr(9)

xrf_map_list = list

BASE_APS_XRF, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_


return, xrf_maps
end
