;+
; FILE 	wrstx_ax.pro
;
; --------------------------- last changed: 06-aug-02 aph
;
; PURPOSE
; Writes out a STXM image in netCDFformat.
;
; INPUT
;   file  = name of file to write
;
; KEYWORDS
;   REAL:  force netCDF file to be real
;
; OPERATION
;
; It assumes that you have put the image and associated information
; into BSIF_COMMON variables:
;   image_data (the array which holds the image - possible several
;		planes deep for I, IO, CLOCK)
;   x_normal, y_normal, rotated, x_title, y_title,
;   x_dist, and y_dist
;
; If "sd" is passed in the argument list, then the STXM scan data
; is assumed to reside in sd.  Otherwise, it is assumed that user_buffer
; contains sd. In the netCDF file, the scan data is written
; as scan data info and not as a user_buffer (since user_buffers
; are inherent to BSIF but are neither encouraged nor disallowed in netCDF).
;
; --------------- REVISION HISTORY ----------------------------
; Based on Mark Rivers stuff; Chris Jacobsen, June 1993.
;
;   the change from version 1.0 to version 1.1 involved simply
;      changing the netCDF attribute "sd.operator" to "operator".
;      Chris Jacobsen, August 27, 1993
;   the change to version 1.2 forces x_title and y_title to
;      be strings rather than byte arrays.  Chris Jacobsen,2-Nov-93

; adapted from Jacobsen's write_stxm routine in stacks (aph 3-mar-98)

; (xx-mar-98 aph) 'taken-over' to isolate from CJJ development
; (14-jun-98 aph) axis_com, bsif_com added
; (15-aug-99 aph) set up to write float data if image_data not integer
; (05-sep-99 aph) add option to force all netCDFs to be written as reals
; (28-dec-01 aph) use better way to determine if image_data is real or not !!
; (06-aug-02 aph) (add Andy Smthi's adaptation to short or long integers

pro wrstx_ax, file, help=help, real=real

@axis_com
@bsif_com

if (keyword_set(help) or (n_elements(file) eq 0)) then begin
  print,'write_stxm,filename,[sd]'
  print,'  Writes STXM data to a netCDF file.'
  print,'  If STXM scan data "sd" is not passed, it is '+$
	'obtained from user_buffer'
  return
endif

;if (n_elements(sd) eq 0) then begin
  ; If sd was not passed, it must be in the BSIF user_buffer.
  ; In that case, copy the user buffer into a STXM scan descriptor structure.
;  copy_stxm_sd, sd
;endif                         ; for AXIS version; SD is in common and is defined
 type = size(image_data, /type)

 ; print, 'wrstx_ax : image data imported as type : ', type ; ***+++***

n_cols = n_elements(image_data(*, 0, 0))
n_rows = n_elements(image_data(0, *, 0))
n_data = n_elements(image_data(0, 0, *))

; Determine the maximum string length of data_title
n_chars = max(strlen(data_title))

; Create output file
cdfid = ncdf_create(file, /CLOBBER)

; Create dimensions
col_id = ncdf_dimdef(cdfid, "n_cols", n_cols)
row_id = ncdf_dimdef(cdfid, "n_rows", n_rows)
data_id = ncdf_dimdef(cdfid, "n_data", n_data)
char_id = ncdf_dimdef(cdfid, "n_chars", n_chars)

; Get NetCDF data type
; data_type = ncdf_datatype(image_data)

; Create variables
; ------------ allow REAL data storage -------
test = image_data(1,1,0)
IF (test - fix(test)) NE 0 OR keyword_set(real) THEN BEGIN
	image_data_id = ncdf_vardef( cdfid, "image_data", $
			 [col_id, row_id, data_id] )
ENDIF ELSE BEGIN
	IF SIZE(image_data, /type) EQ 2 THEN BEGIN 	; ***+++*** ADS
		image_data_id = ncdf_vardef( cdfid, "image_data", $
				 [col_id, row_id, data_id], /short )
	ENDIF ELSE BEGIN	; ***+++*** ADS
		image_data_id = ncdf_vardef( cdfid, "image_data", $
				 [col_id, row_id, data_id], /long ) 	; ***+++*** ADS
	ENDELSE		; ***+++*** ADS
ENDELSE
;if size(image_data(1,1,0),/type) EQ 4 OR keyword_set(real) then begin
;	image_data_id = ncdf_vardef( cdfid, "image_data", $
;			 [col_id, row_id, data_id] )
;endif else begin
;	image_data_id = ncdf_vardef( cdfid, "image_data", $
;			 [col_id, row_id, data_id], /short )
;endelse

data_title_id = ncdf_vardef( cdfid, "data_title", $
			 [char_id, data_id], /char )
; x_dist_id = ncdf_vardef( cdfid, "x_dist", $
;			[col_id], /float )
; y_dist_id = ncdf_vardef( cdfid, "y_dist", $
;			[row_id], /float )

; netCDF doesn't like strings of length zero.
x_title=strtrim(string(x_title),2)
if (strlen(x_title) eq 0) then x_title=' '
y_title=strtrim(string(y_title),2)
if (strlen(y_title) eq 0) then y_title=' '
date_time=strtrim(string(sd.date_time),2)
if (strlen(date_time) eq 0) then date_time=' '
operator=strtrim(string(sd.operator),2)
if (strlen(operator) eq 0) then operator=' '
sample=strtrim(string(sd.sample),2)
if (strlen(sample) eq 0) then sample=' '
zone_plate=strtrim(string(sd.zone_plate),2)
if (strlen(zone_plate) eq 0) then zone_plate=' '
comment1=strtrim(string(sd.comment1),2)
if (strlen(comment1) eq 0) then comment1=' '
comment2=strtrim(string(sd.comment2),2)
if (strlen(comment2) eq 0) then comment2=' '
file_name=strtrim(string(sd.file_name),2)
if (strlen(file_name) eq 0) then file_name=' '

; Define global attributes
ncdf_attput, cdfid, /GLOBAL, "title", image_title
stxm_netcdf_version='1.2'
ncdf_attput, cdfid, /GLOBAL, "stxm_netcdf_version", stxm_netcdf_version

; Save attributes for BSIF stuff
ncdf_attput, cdfid, image_data_id, "x_normal", x_normal
ncdf_attput, cdfid, image_data_id, "y_normal", y_normal
ncdf_attput, cdfid, image_data_id, "rotated", rotated
ncdf_attput, cdfid, image_data_id, "x_start", x_start
ncdf_attput, cdfid, image_data_id, "x_stop", x_stop
ncdf_attput, cdfid, image_data_id, "y_start", y_start
ncdf_attput, cdfid, image_data_id, "y_stop", y_stop
ncdf_attput, cdfid, image_data_id, "x_title", x_title
ncdf_attput, cdfid, image_data_id, "y_title", y_title

; Save attributes for scan data stuff
ncdf_attput, cdfid, image_data_id, "version_number", sd.version_number
ncdf_attput, cdfid, image_data_id, "scan_driver_mode", sd.scan_driver_mode
ncdf_attput, cdfid, image_data_id, "scan_width", sd.scan_width
ncdf_attput, cdfid, image_data_id, "scan_height", sd.scan_height
ncdf_attput, cdfid, image_data_id, "i0_mode", sd.i0_mode
ncdf_attput, cdfid, image_data_id, "clock_frequency", sd.clock_frequency
ncdf_attput, cdfid, image_data_id, "sd_x_start", sd.x_start
ncdf_attput, cdfid, image_data_id, "sd_x_stop", sd.x_stop
ncdf_attput, cdfid, image_data_id, "x_center", sd.x_center
ncdf_attput, cdfid, image_data_id, "x_step_size", sd.x_step_size
ncdf_attput, cdfid, image_data_id, "sd_y_start", sd.y_start
ncdf_attput, cdfid, image_data_id, "sd_y_stop", sd.y_stop
ncdf_attput, cdfid, image_data_id, "y_center", sd.y_center
ncdf_attput, cdfid, image_data_id, "y_step_size", sd.y_step_size
ncdf_attput, cdfid, image_data_id, "z_start", sd.z_start
ncdf_attput, cdfid, image_data_id, "z_stop", sd.z_stop
ncdf_attput, cdfid, image_data_id, "z_center", sd.z_center
ncdf_attput, cdfid, image_data_id, "z_step_size", sd.z_step_size
ncdf_attput, cdfid, image_data_id, "focus_position", sd.focus_position
ncdf_attput, cdfid, image_data_id, "dwell_time", sd.dwell_time
ncdf_attput, cdfid, image_data_id, "x_prescan_distance", $
	sd.x_prescan_distance
ncdf_attput, cdfid, image_data_id, "y_prescan_distance", $
	sd.y_prescan_distance
ncdf_attput, cdfid, image_data_id, "x_postscan_distance", $
	sd.x_postscan_distance
ncdf_attput, cdfid, image_data_id, "x_postscan_distance", $
	sd.x_postscan_distance
ncdf_attput, cdfid, image_data_id, "flyback_velocity", sd.flyback_velocity
ncdf_attput, cdfid, image_data_id, "entrance_slit", sd.entrance_slit
ncdf_attput, cdfid, image_data_id, "exit_slit", sd.exit_slit
ncdf_attput, cdfid, image_data_id, "wavelength", sd.wavelength
ncdf_attput, cdfid, image_data_id, "date_time", date_time ; fixed above
ncdf_attput, cdfid, image_data_id, "operator", operator ; fixed above
ncdf_attput, cdfid, image_data_id, "sample", sample ; fixed above
ncdf_attput, cdfid, image_data_id, "zone_plate", zone_plate ; fixed above
ncdf_attput, cdfid, image_data_id, "comment1", comment1 ; fixed above
ncdf_attput, cdfid, image_data_id, "comment2", comment2 ; fixed above
ncdf_attput, cdfid, image_data_id, "file_name", file_name ; fixed above
ncdf_attput, cdfid, image_data_id, "ring_current", sd.ring_current
ncdf_attput, cdfid, image_data_id, "undulator_gap", sd.undulator_gap
ncdf_attput, cdfid, image_data_id, "idling_time", sd.idling_time
ncdf_attput, cdfid, image_data_id, "auto_shutter", sd.auto_shutter
ncdf_attput, cdfid, image_data_id, "x_pzt_offset", sd.x_pzt_offset
ncdf_attput, cdfid, image_data_id, "y_pzt_offset", sd.y_pzt_offset
ncdf_attput, cdfid, image_data_id, "initial_lambda", sd.initial_lambda
ncdf_attput, cdfid, image_data_id, "final_lambda", sd.final_lambda
ncdf_attput, cdfid, image_data_id, "sgm_step_size", sd.sgm_step_size
ncdf_attput, cdfid, image_data_id, "dx_dl", sd.dx_dl
ncdf_attput, cdfid, image_data_id, "dy_dl", sd.dy_dl
ncdf_attput, cdfid, image_data_id, "dz_de", sd.dz_de

; End define mode
ncdf_control, cdfid, /ENDEF

; Write out data
ncdf_varput, cdfid, image_data_id, image_data
ncdf_varput, cdfid, data_title_id, data_title
; ncdf_varput, cdfid, x_dist_id, x_dist
; ncdf_varput, cdfid, y_dist_id, y_dist

; Close file
ncdf_close, cdfid

return
end


