; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SAV_HDFM
;
;LAST CHANGED: ----------------------------------- 	21 Jul 2014
;
; PURPOSE:
;	This procedure writes series of NSLS files as HDF 2d
; scientific data format files
; used to transfer files from AXIS to ENVI
;-
;
; CATEGORY:
;	data I/O.
;
; CALLING SEQUENCE:
;	SAV_HDFM [list=list, fltr=fltr]
;
; INPUTS: none
;
; KEYWORDS:
;	LIST:	list of data files to convert
;	FLT:	extension of data files
;
; OUTPUTS:
;	HDF file written
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (18-jun-98aph) adapted from MakeHFDdata in idl40\examples\hdf_netcdf\hdf_rdwr.pro
; (21-Jul-14 aph) AXIS standard header added
;-

PRO sav_HDFm, list=list, fltr=fltr
on_error,2
@axis_com
@bsif_com

if keyword_set(list) then begin
   osname=strupcase(strmid(!version.os,0,3))
   stack_readlist, list, filename_list
endif else begin
if n_elements(file) eq 0 then begin  ;popup file dialog box
   if not keyword_set(fltr) then fltr='*.sln'
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath)
endif
filename_list=file
endelse

n_files = n_elements(filename_list)
FOR i_file = 0,n_files-1 DO BEGIN
	file = filename_list(i_file)
    tmp = read_bnl(file)
	IF n_tags(tmp) NE 0 then BEGIN
  	  if tmp.t EQ '2d' then BEGIN
  	    energy = 12398.0/sd.wavelength
	 	spos=strpos(file,'.')
		if (spos ne -1) then file=strmid(file,0,spos)   ; strip extension
		file=strlowcase(file)
	    file = file + '.hdf'
		fileshort=strmid(file,strlen(file)-12, strlen(file)-4)   ; assumes file names are 8.3
	    lbl = tmp.dl  + ' E(eV)= ' + strcompress(string(energy))
;	Create (or overwrite) a Scientific Data Set (SDS)
		HDF_DFSD_SETINFO,	$
			/CLEAR,		$		; Reset SDS internal vars.
			/FLOAT,		$		; Data is floating point
			DIMS=[n_elements(tmp.x),n_elements(tmp.y)],	$
			LABEL=lbl, $		; TITLE=...
			UNIT="um"			; UNITS=...
		HDF_DFSD_DIMSET, 0, LABEL=tmp.xl
		HDF_DFSD_DIMSET, 1, LABEL=tmp.yl
; Create and write the data
		HDF_DFSD_ADDDATA, file, tmp.d, /OVERWRITE
   	 endif
	 WIDGET_CONTROL,UPrompt, SET_VALUE='NSLS_to_HDF '+ fileshort $
	   + '       E(eV)= '+strcompress(string(energy))
   ENDIF
ENDFOR
END


