; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		LN_SUBSP
;

;LAST CHANGED: ----------------------------------- 21-Jul-14 (aph)
;
; PURPOSE:
;	This procedure subtracts a reference spectrum (chosen from an AXIS buffer)
; from the linescan displayed in the current buffer

; CATEGORY: data conversion - AXIS captive
; called from AXIS~LINESCANS~subtract reference
;
; CALLING SEQUENCE:
;	LNSUBSP
;
; INPUTS:none
;
; KEYWORDS: none
;
; OUTPUTS: none
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (01-jan-99 aph) segregated from aaa-axis
; (23-feb-00 aph) add groupID to buffer
; (29-dec-00 aph) fix error in name of groupID !!
;	        add standard header; remove line-by-line display
; (21-Jul-14 aph) corrected header
;-

PRO ln_subsp

@axis_com

HANDLE_VALUE, Data(CurBuf), tmp     ;Get the data
IF n_tags(tmp) EQ 0 THEN RETURN
WIDGET_CONTROL, Uprompt, SET_VALUE='Linescans: subtract reference'
SetGraf, 'MainImg'
bt = Buffer(group=axis_ID)  	;Get buffer containing Io from user
if bt EQ -1 THEN RETURN
HANDLE_VALUE, Data(bt),tmp2
IF n_tags(tmp2) ne 0 THEN BEGIN
	WIDGET_CONTROL, /Hourglass
    yd = tmp.d(*,0)                                  ; set up first line
    tmp1 = {t:'1d', x:tmp.x, d:yd, xl:tmp.xl, dn:yd, dl:tmp.dl}
; Interpolate reference  signal to data range of linescan
	xmin = fltarr(2) & xmax = fltarr(2)               ; identify common range
	xmin(0) = min(tmp1.x) & xmin(1) = min(tmp2.x)
	xmax(0) = max(tmp1.x) & xmax(1) = max(tmp2.x)
	xmin = max(xmin) & xmax = min(xmax)
	xval1 = where(tmp1.x GE xmin AND tmp1.x LE xmax, nt1)   ; check there is in-range data
	xval2 = where(tmp2.x GE xmin AND tmp2.x LE xmax, nt2)   ; in both buffers
	if nt1 NE 0 AND nt2 NE 0 then BEGIN
		Xvals1 = where(tmp1.x GE xmin AND tmp1.x LE xmax)
		Xvals2 = where(tmp2.x GE xmin AND tmp2.x LE xmax)
		x1 = tmp1.x(Xvals1)   ; trim arrays to common range
		d1 = tmp1.d(Xvals1)   ; NB must use intermediate arrays!!
		x2 = tmp2.x(Xvals2)
		d2 = tmp2.d(Xvals2)
		n=where(x1,nt1)  & n=where(x2,nt2)
		y2 = Interpol(d2, x2, x1)        ; mesh to linescan data set
	endif  else begin
		print, 'No common energy values'
		goto, nogo_ref
	endelse
; set up structure for modified data on [xmin,xmax] range
    new = {t:'2d',x:x1,y:tmp.y,xl:tmp.xl,yl:tmp.yl,d:tmp.d(Xvals1,*),dl:tmp.dl}
  	for i = 0, n_elements(tmp.y)-1 do begin
    	yd = tmp.d(Xvals1,i)
		d = yd - y2
; assemble modified image  - will need to compensate for changing line lengths
		new.d(*,i) = d
	endfor
	ymin = min(new.d,max=ymax)
; Trace path  through linescan ------
;		  	for i = 0, n_elements(tmp.y)-1 do begin
;				device, get_graphics = oldgraph, set_graphics = 6      ;Set xor
;	   			if i GT 0 then plots, [xmin,xmax],[tmp.y(i-1),tmp.y(i-1)],/data, thick=1
;	   			plots, [xmin,xmax],[tmp.y(i),tmp.y(i)],/data, thick=1
;	   			device, set_graphics = oldgraph   ; reset graphics mode
;	            SetGraf,'XZPlot'
;	            plot,x1,d,charsize=0.8,yrange=[ymin,ymax],ystyle=5,psym=0,ymargin=[3,0],xstyle=1
;      WIDGET_CONTROL, Uprompt, SET_VALUE='Line '+strcompress(string(i))
;	        endfor
	new.dl = new.dl + '- ref.'
	HANDLE_VALUE,Data(0),new,/set
	CurBuf = 0
	PlotBuf,CurBuf
ENDIF
nogo_ref :
END
