; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_BINF
;
;LAST CHANGED: ----------------------------------- 29-Oct-11
;
;PURPOSE:
;	This function bins an image provided as a aXis2000 2d structure
;
;CATEGORY:
;	AXIS: data analysis; stand alone
;
;CALLING SEQUENCE:
;	RESULT = AX_BINF(image, bin=bin)
;
;CALLED FROM AXIS:
;	-> used in read_bessy_txm.pro (large CCD images)
;
;INPUTS:
;	image = aXis2000 2d structure
;
;KEYWORDS:
;	AXIS	= flag to identify called from AXIS
;	BIN =  number of (#x#) pixels (or energies)  to average
;	SILENT 	flag, if set, do not print tracking comments
;
;OUTPUTS:
;	returns the binned image and modifed x, y scales as a replacement structure
;
;COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;	BSIF_COM	NetCDF common block

;MODIFICATION HISTORY:
; (29-Oct-11 aph) first evolved from ax_bin procedure
;-

FUNCTION  ax_binf, image, silent=silent, axis=axis, bin=bin
@axis_com
@bsif_com

; determine if AXIS is running - i.e  any widget active
if  keyword_set(axis) then axis_on = 1 else axis_on = widget_info(/active)

IF  not Keyword_Set(bin) THEN BEGIN
	 bin = 2
	if axis_on then begin
		bin = get_num(prompt='bin factor ', val=bin, group = axis_ID)
	endif else begin
		bin = get_num(prompt='bin factor ', val=bin)
	endelse
ENDIF

; if widget_info(/active) EQ 1 then widget_control, /hourglass

; -------------- in this case list is a 2d array which will be binned
s= 0.
if  n_tags(image) EQ 0 THEN BEGIN
	axis_log, 'ax_bin:  data provided is not an aXis2000 structure'
	return, s
endif

if  image.t NE '2d' THEN BEGIN
	axis_log, 'ax_bin:  aXis2000 structure is not 2d'
	return, s
endif

; ----- bin the provided image, with truncation if needed  --------
n_cols = n_elements(image.x)
n_rows = n_elements(image.y)
if (float(n_cols)/float(bin))-fix(n_cols/bin) GT 0 $
	OR (float(n_rows)/float(bin))-fix(n_rows/bin) then begin
    nct =fix(n_cols/bin)*bin  &  nrt = fix(n_rows/bin)*bin
    xtra_c = n_cols - nct + 1
    xtra_r = n_rows - nrt + 1
 if not keyword_set(silent) then print, 'truncate image to ', fix(nct), fix(nrt)
 ;   x_stop = x_stop*float(nct)/float(n_cols)  ; correct axis length for truncation
 ;   y_stop = y_stop*float(nrt)/float(n_rows)
    tmp = image.d                      ;force size to integer mutiple of bin
    tmp2 = fltarr(nct,nrt)
	tmp2 = tmp(0:n_cols-xtra_c,0:n_rows-xtra_r)
endif
n_cols = fix(nct/bin)
n_rows = fix(nrt/bin)
if not keyword_set(silent) then  begin
	print, 'bin image ', fix(bin), ' times,  to ',n_cols,'  x', n_rows
	print, 'in process the x-axis loses ', xtra_c-1, ' points'
	print, '           the y-axis loses ', xtra_r-1, ' points'
endif
tmp = rebin(tmp2,n_cols,n_rows)

; -------- generate binned x, y, arrays
x_step = (image.x(n_elements(image.x)-xtra_c-1) - image.x(0)) / n_cols
y_step = (image.y(n_elements(image.y)-xtra_r-1) - image.y(0)) / n_rows
x = image.x(0) + findgen(n_cols)* x_step
y = image.y(0) + findgen(n_rows)* y_step
dl = image.dl + ' bin-' + strtrim(string(bin),2)
tmp = {t:'2d', d:tmp, x:x, y:y, e:image.e, xl: image.xl, yl:image.yl, dl: dl}
return, tmp

bailout:
print,'Bailing out of AX_BIN because of an error'
close,/all
return, s
END
