; Copyright (c) 1998-2010 J. Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AA_WriteConfig.pro
;
;LAST CHANGED: ----------------------------------- 	23-Jul-10
;
; PURPOSE:
;	This function writes the configuration file for the XSpecSim program
;
; CATEGORY:
;	Utility; part of XSpecSim, spectral simulator package
;
; CALLING SEQUENCE:
;	Result = AA_WriteConfig(AAPATH = AAPATH)
;
; INPUTS: none
;
; KEYWORDS:
;	AApath	name of folder inside aXis2000 code directory
;
; OUTPUTS:
;	configuration file is written
;
;COMMON BLOCKS:
;	axis_com
;	XSpecSim_Com		X-SpecSim common block
;
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (18-Jul-10 aph) AXIS standard header added;
;                 axis_com and XSpecSim_com added
; (23-Jul-10 aph) modified parameter in call from 'file' to 'AApath'
;-

pro AA_WriteConfig, AApath=AApath
@axis_com
@XSpecSim_com

	if n_elements(sf_path) EQ 0 then sf_path = 'C:\Axis2000\sfdata\'
	print, 'SF path = ', sf_path

	if not Keyword_set(AApath) then AAPath='AAData' + ax_sep()

	initfile= CodePath + AApath + 'AA_Init.ini'

	get_lun,lun
	openw, lun, initfile
		printf, lun, curdat
		printf, lun, curen
		printf, lun, SaveSf
		printf, lun, basepath
		Printf, lun, SF_Path
		Printf, lun, ';first line: index of dataset last used'
		Printf, lun, ';Second line: index of energy set last used'
		Printf, lun, ';Third Line: Save SF on or off'
		Printf, lun, ';Fourth line is the default path '
		Printf, lun, 'Fifth Line is the path to the SF data files
	close, lun
	free_lun,lun
end