; Copyright (c) 1998-2024 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	READ_NANOMAX_STACK_E_BY_E.PRO
;;
;LAST CHANGED: ----------------------------------- 	26 Mar 2024 (aph)

; PURPOSE:
;	This function reads a set of images using the read_nanomax_image routine to read NanoMAX h5 files
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
;	RESULT = READ_NANOMAX_PTYCHO_STACK(path=path, verbose=verbose, group = group)
;
; INPUTS: none
;
; KEYWORDS:
;	PARTH
;	VERBOSE
;	GROUP
;
; OUTPUTS:  stack as (*.dat, *.ncb)
;
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks
; stack_process_com
; COMMON volume_data, image_stack
; bsif_com


; MODIFICATION HISTORY:
; (26-Mar-24 aph) first version
; (04-Apr-24 aph) set up only for diode stacks where the individual images are in the \raw folder
;-

FUNCTION  read_nanomax_stack_e_by_e, path=path, silent=silent, verbose=verbose, group = group
@axis_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com

on_error,2

null = 0


; ------------ select NanoMAX  *.h5 file(s)

filelist = dialog_pickfile(title='Select NanoMAX stack  *.h5 files',filter=['*.h5'], path=DefPath, get_path=folder_path, /multiple_files)
DefPath=folder_path
cd, DefPath
print, DefPath

; help, filelist

n_e = n_elements(filelist)
n_data= n_e

ev=fltarr(n_e)

; read first image to set up dimensions of stack

a = read_nanomax_ptycho(file=filelist(0))   ;, /silent)
nx = n_elements(a.x)
ny = n_elements(a.y)

filename_ev_msec_list = strarr(n_e)

image_stack = fltarr(nx, ny, n_e)

; ---------- loop through to get all images of the stack
for i = 0, n_e-1 do begin
	tmp = read_nanomax_ptycho(file=filelist(i), /silent)
	image_stack(*,*,i) = exp(tmp.d)								; exponentiate since Maik Khn logged prior to normaization to alda2.1 ion chamber signal
	t = ax_name(filelist(i))
	ev(i) = tmp.e
	filename_ev_msec_list(i) = t(1) + '  '+ string(ev(i))
	axis_log, filename_ev_msec_list(i)
endfor

if n_elements(stack_file) LT 0 then stack_file = ' '
stack_file = get_text(prompt = 'name of stack ', val = stack_file)
stack_file = DefPath + stack_file
stack_wb, stack_file, /real



return, null

end