; Copyright (c) 1998-2015 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_CRYO_STXM
;
;LAST CHANGED: ----------------------------------- 	28 Feb 2015
;
; PURPOSE:
;	This procedure reads in a set of ascii images, without headers
;
; CATEGORY:
;	Image read-in. Stand alone
;
; CALLING SEQUENCE:
; READ_CRYO_STXM

; INPUTS: none
;
; KEYWORDS: none
;
; OUTPUTS: stack saved
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (28-Feb-15 aph) first version. For data measured 13-Feb-15.
;          Russ Berg supposed to be using hdf5 (which is binary) but data sent as ascii

PRO read_cryo_stxm
@axis_com
@ax_peem_com
@tif_convert_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com
@sdf_com

; ------  get list of files
  filelist=dialog_pickfile(filter='*.xim', /multiple_files)

; read 1 file to get size and ask for dimensions
	tmp = read_ascii_img(file=filelist(0))

; define size of the stack
	n_data = n_elements(filelist)
	n_cols = n_elements(tmp.x)
	n_rows = n_elements(tmp.y)
	image_stack = fltarr(n_cols, n_rows, n_data)
	x_stop = get_num(prompt = ' length of x-axis', val = x_stop)
	y_stop = get_num(prompt = ' length of y-axis', val = y_stop)
	x_start = 0
	y_start = 0
	ev =fltarr(n_data)
	filename_ev_msec_list=strarr(n_data)
	E_start = get_num(prompt = ' first energy', val = E_start)
	E_step  = get_num(prompt = '  energy step', val = E_step)
; read each file & apply (x,y, values); E as index - change later with stack_process
  for i = 0, n_elements(filelist)-1 do begin
  		tmp = read_ascii_img(file=filelist(i))
  		image_stack(*,*,i) =tmp.d
  		ev(i) = E_start + i*E_step
  		filename_ev_msec_list(i) = filelist(i)
  endfor
  outfile=pickfile2(prompt='Name of cryo-STXM stack file', filter='*.ncb')
  stack_wb, outfile
END