; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_ADD
;
;LAST CHANGED: ----------------------------------- 21-apr-05
;
;PURPOSE:
;	This procedure interpolates then sums the y-values over the
; common x-axis range of two 1-d structures (spectra) in AXIS
;
;CATEGORY:
;	AXIS: spectra analysis
;
;CALLING SEQUENCE:
;	AXIS_ADD
;
;CALLED FROM AXIS:
;	Spectra->Add->Buffers
;
;INPUTS: none
;
;KEYWORDS: none
;
;OUTPUTS:
;	The sum of the spectra is placed in buffer 0.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
;	The user is prompted for a scale factor for first file,
; the buffer of the second file, and a scale factor for the second file.
;
;MODIFICATION HISTORY:
; (09-aug-97 aph) split out from axis_c
; (29-dec-97 aph) remembers numerical factors
; (14-jun-98 aph) axis_com
; (13-dec-98 aph) allow for cancel when choosing 2nd buffer
; (08-jun-99 aph) add group call to get_num
; (30-dec-99 aph) use AX_MESH to interpolate
; (23-feb-99 aph) add groupID to buffer call
; (02-jan-00 aph) AXIS standard documentation
; (21-apr-05 aph) use FIRST keyword for axis_mesh to force E-scale to that of first file
;                 when interpolating spectra
;-
PRO axis_add
@axis_com
on_error,2

HANDLE_VALUE, Data(Curbuf), tmp1
IF n_tags(tmp1) EQ 0 THEN return
If tmp1.t EQ '1d' then begin
    WIDGET_CONTROL, Uprompt, SET_VALUE='Weighted sum of 2 buffers'
    s1 = Get_num(PROMPT = 'scale for first buffer', val=factor(0), group = axis_id)
    factor(0)=s1
    b = Buffer(group = AXIS_ID)
    IF b EQ -1 then return
    PlotBuf, b
	s2 = Get_num(PROMPT = 'scale for second buffer', val=factor(1), group = axis_id)
	factor(1)=s2
	HANDLE_VALUE, Data(b(0)), tmp2
	IF n_tags(tmp2) EQ 0 THEN RETURN
	IF tmp2.t EQ '1d' then begin
		t = ax_mesh(tmp1, tmp2, 1, /first)
		IF t EQ 1 then begin
			y1 = tmp1.d & y2 = tmp2.d
			d = s1*y1 + s2*y2
			text = string(format='(G10.2,A," + ",G10.2,A)', s1, tmp1.dl,s2,tmp2.dl)
			dl = text
			tmp = {t:'1d',x: tmp1.x, d:d, xl:tmp1.xl, dn:d, dl:dl}
			HANDLE_VALUE, Data(0), tmp, /SET
	    	PlotBuf, 0
	    	WIDGET_CONTROL, Uprompt, SET_VALUE=''
		ENDIF ELSE  WIDGET_CONTROL, Uprompt, SET_VALUE='Buffers do not overlap. ADD not performed'
	ENDIF ELSE WIDGET_CONTROL, Uprompt, SET_VALUE='Add Buffers: incompatible data'
ENDIF ELSE WIDGET_CONTROL, Uprompt, SET_VALUE='Add Buffers: not a spectrum'
END