; Copyright (c) 1998-2019 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_WEB
;
;LAST CHANGED: ----------------------------------- 03 Jan 2023 (aph)
;
;PURPOSE:
;	This procedure executes a net browser command to access
; synchrotron or other sites via the web.
; The browser command will be system / computer specific and is
; contained in the axis.ini initialization file
;
;CATEGORY:
;	AXIS: utility (captive)
;
;CALLING SEQUENCE:
;	AXIS_WEB, event_X, event_Y
;
;CALLED FROM AXIS:
;	executed while the earth logo visible only
;
;INPUTS:
;	EVENT_X - from Xmanager, X-value of pixel clicked
;	EVENT_Y - from Xmanager, Y-value of pixel clicked
;
;KEYWORDS:
;	SITE - code for web site to go to (to use from "utilities/XRM sites")
;
;OUTPUTS:
;	A new window with the web info is generated.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;SIDE EFFECTS:
;	A window is created/destroyed.
;
;PROCEDURE:
;	uses IDL spawn command. The form of the Net command MUST be one
; that will operate from an MS-DOS window in win-95. Thus 8.3 file names and
; no embedded blanks in paths.
;
;
;MODIFICATION HISTORY:
; (31-jan-00 aph) first created; adapted to variable size
; (22-aug-00 aph) add link to aXis2000 home base
; (22-aug-01 aph) update axis2000 home base
; (25-Feb-08 aph) update web links
; (21-feb-10 aph) add Elettra, SSRL, update all links and test
; (04-jun-18 aph) update default browser to chrome
; (26-jun-19 aph) get working & correct navigation and sites
; (03-Jan-23 aph) get working - problem was space in the path to the browser! DAMN "program files" !!!!!!
;-

PRO axis_web, event_X, event_Y, site = site

@axis_com
on_error,2

if net_command EQ '' then net_command = ' "firefox.exe" '

 print, 'net_command is |', net_command, '|'

if NOT keyword_set(site) then begin
    site = 'nowhere'
		webx = fix(float(event_x)/gr_scale)
		weby = fix(float(event_y)/gr_scale)

	print, webx, weby

	if webx GE 0 AND webx LE 120 then begin
		if weby GE 250 AND weby LE 280 then site = 'ALS'
		if weby GE 230 AND weby LE 249 then site = 'Alba'
		if weby GE 200 AND weby LE 229 then site = 'Bessy'
		if weby GE 170 AND weby LE 195 then site = 'CLS'
		if weby GE 145 AND weby LE 165 then site = 'Diamond'
		if weby GE 115 AND weby LE 140 then site = 'Elettra'
		if weby GE  85 AND weby LE 110 then site = 'Max IV'
	endif
	if webx GE 200 AND webx LE 360 then begin
		if weby GE 250 AND weby LE 295 then site = 'NSRRC'
		if weby GE 230 AND weby LE 250 then site = 'PLS'
		if weby GE 185 AND weby LE 225 then site = 'Photon Factory'
		if weby GE 165 AND weby LE 185 then site = 'SLS'
		if weby GE 140 AND weby LE 165 then site = 'Soleil'
		if weby GE 110 AND weby LE 135 then site = 'SSRL'
		if weby GE  90 AND weby LE 110 then site = 'UVSOR'
	endif else begin
		if weby LT 70 then site = 'AXIS2000'
	endelse
endif
site = strtrim(site, 2)

 print, 'Contacting XRM web site: ', site

CASE site OF

'ALS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ALS web site . . .  exit browser to continue '
	spawn, net_command + ' https://als.lbl.gov/beamlines/5-3-2-2/', /noshell
   end

'Alba': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Alba web site . . . exit browser to continue  '
	spawn, net_command + ' https://intranet.cells.es/Beamlines/XM/', /noshell
  end

'Bessy': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Bessy MAXYMUS web site . . . exit browser to continue  '
	spawn, net_command + ' https://www.helmholtz-berlin.de/pubbin/igama_output?modus=einzel&sprache=en&gid=1885', /noshell
  end

'CLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting CLS web site . . . exit browser to continue '
	spawn, net_command + ' https://sm.lightsource.ca/', /noshell
  end

'Diamond': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Diamond STXM web site . . . exit browser to continue '
	spawn, net_command + ' https://www.diamond.ac.uk/Instruments/Imaging-and-Microscopy/I08.html', /noshell
  end

'Elettra': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting ELETTRA Twinmic web site . . . exit browser to continue '
	spawn, net_command + ' https://www.elettra.trieste.it/it/lightsources/elettra/elettra-beamlines/twinmic/twinmic.html', /noshell
  end

'Max IV': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Max IV Softimax web site . . . exit browser to continue '
	spawn, net_command + ' https://www.maxiv.lu.se/beamlines-accelerators/beamlines/softimax/', /noshell
  end

'NSRRC': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting NSRRC STXM web site . . .exit browser to continue  '
	spawn, net_command + ' https://www.nsrrc.org.tw/English/research8_1_peem.aspx/', /noshell
   end

'PLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting PLS web site . . . exit browser to continue '
	spawn, net_command + ' http://pal.postech.ac.kr/paleng/bl/10A/', /noshell
   end

'Photon Factory': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Photon Factory web site . . . exit browser to continue '
	spawn, net_command + ' https://www.kek.jp/en/Facility/IMSS/PF/PFRing/Imaging/', /noshell
   end

'SLS': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting  SLS Pollux web site . . . exit browser to continue '
	spawn, net_command + ' https://www.psi.ch/en/sls/pollux', /noshell
   end

'Soleil': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting Soleil HERMES web site . . . exit browser to continue '
	spawn, net_command + ' https://www.synchrotron-soleil.fr/en/beamlines/hermes/', /noshell
   end

'SSRL': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting SSRL web site . . . exit browser to continue '
	spawn, net_command + ' https://www-ssrl.slac.stanford.edu/content/beam-lines/bl13-1/', /noshell
   end

'UVSOR': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting UVSOR STXM web site . . . exit browser to continue '
	spawn, net_command + ' https://www.uvsor.ims.ac.jp/staff/BL4U/index.html', /noshell
   end

'AXIS2000': begin
	WIDGET_CONTROL, Uprompt, SET_VALUE= 'contacting aXis2000 web site . . . exit browser to continue '
	print, 'Net command is,', net_command
	spawn, net_command + ' http://unicorn.mcmaster.ca/aXis2000.html', /noshell
   end

   else: print, 'This web site is unknown'

ENDCASE

end
