;+ 
;NAME: 
;	INTERP.PRO 
; 
;LAST CHANGED: ----------------------------------- 08-nov-00 
; 
;PURPOSE: 
;	Interpolates values
;	may be obsolete and might be eliminated
; 
;CATEGORY: 
;	STAND ALONE: utilities 
; 
;CALLING SEQUENCE: 
;	Result = INTERSPLINE(Yin,FIXEDY=FY) 
; 
;CALLED FROM AXIS: 
;	many procedures 
; 
;ROUTINES 
;	function INTERSPLINE, Yin, FIXEDY=FY
;	pops up an interactive window; user uses cursor to define a spline smooth function
;	returns a spline-fitted array of the same length as yin
;	if fixedy is set, then y-values of spline are constrained to lie on the data.
; 
;COMMON BLOCKS: none 
; 
;MODIFICATION HISTORY: 
; (08-nov-00 cgz) AXIS standard documentation 
; (08-nov-00 cgz) migrated from MATH.PRO
;- 
; ******************************************************************************* 


function interspline,yin,fixedy=fy
  on_error,2
  wstore=!d.window
  window,31,title='Interactive spline smooth (win#31)',xsize=600,ysize=600
  plot,yin,xstyle=1,ystyle=1
  print,'enter new points with left mouse, undo with middle mouse, right button exits'
  p=fltarr(1000) ; up to 1000 points
  yp=p
  n=0
  exit=0
  while exit eq 0 do begin
    cursor,x,y
    case !err of 
    1:begin ;left mouse pressed
        if n gt 0 then cond=(round(x) ne p(n-1)) else cond=1
        if cond then begin ;trap double clicks in same spot
          if n gt 0 then oplot,p(0:n-1),yp(0:n-1),psym=-2,color=0 ;erase old points
          p(n)=round(x)
	  if keyword_set(fy) then yp(n) = yin(p(n)) else yp(n)=y
          ps=p(0:n) & yps=yp(0:n)
          ps=ps(sort(ps)) & p(0:n)=ps(0:n)
          yps=yps(sort(ps)) & yp(0:n)=yps(0:n)
          oplot,p(0:n),yp(0:n),psym=-2,color=128
          n=n+1
        endif
      end
    2:begin ; middle mouse pressed -- delete last point from list
        if n eq 1 then print, 'OUCH' else begin
          oplot,p(0:n-1),yp(0:n-1),psym=-2,color=0 ;erase old
          n=n-1
	  ps=p(0:n) & yps=yp(0:n)
          ps=ps(sort(ps)) & p(0:n)=ps(0:n)
          yps=yps(sort(ps)) & yp(0:n)=yps(0:n)
          oplot,p(0:n-1),yp(0:n-1),psym=-2,color=128 ;plot new
        endelse
      end
    4:exit=1 ;right mouse pressed
    endcase
    if n gt 0 then print,n,'>',p(0:n-1)
  endwhile
  p=p(0:n-1)
  yp=yp(0:n-1)
  y2=nr_spline(p,yp)
  x=findgen(n_elements(yin))
  y=nr_splint(p, yp, y2, x)
  oplot,x,y
  wset,wstore
  return,y
end

