FUNCTION  fix_rollover_test, tmp
@axis_com
@bsif_com
on_error,2

; ----------- fix (2**16) OR user defined roll_over
; IF keyword_set(one) then begin

; scan each column to find changes of adjacent rows which are larger than the threshold
;  for 2-pi phase roll-over a change of +3.14 means subtract 2pi (6.2832) from esubsequent rows by  until next time threshold is succeeded
;  for 2-pi phase roll-over a change of -3.14 means need to add 2pi (6.2832) to subsequent rows by 2pi (6.28318530718) until next time threshold is succeeded
 	for i = 0, n_elements(tmp.x)-1 do begin
 		change = 0
 		for j = 1, n_elements(tmp.y)-1  do begin
 			if abs(tmp.d(i,j) - tmp.d(i,j-1)) GT threshold then begin
; 				print, i, '   ',j, '     ', tmp.d(i,j+1) - tmp.d(i,j)
 			      if tmp.d(i,j) - tmp.d(i,j-1) GE 0 then change = -1.*offset else  change = offset
 			endif
 			tmp.d(i,j) = tmp.d(i,j) + change
 			change = 0
 		endfor
	endfor

; NOW do the same from the x-direction
 	for j = 0, n_elements(tmp.y)-1 do begin
 		change = 0
 		for i = 1, n_elements(tmp.x)-1  do begin
 			if abs(tmp.d(i,j) - tmp.d(i-1,j)) GT threshold then begin
 			      if tmp.d(i,j) - tmp.d(i-1,j) GE 0 then change = -1.*offset else  change = offset
 			endif
 			tmp.d(i,j) = tmp.d(i,j) + change
 			change = 0
 		endfor
	endfor
; NOW do the same from the y-direction again
	 	for i = 0, n_elements(tmp.x)-1 do begin
	 		change = 0
	 		for j = 1, n_elements(tmp.y)-1  do begin
	 			if abs(tmp.d(i,j) - tmp.d(i,j-1)) GT threshold then begin
; 				print, i, '   ',j, '     ', tmp.d(i,j+1) - tmp.d(i,j)
	 			      if tmp.d(i,j) - tmp.d(i,j-1) GE 0 then change = -1.*offset else  change = offset
	 			endif
	 			tmp.d(i,j) = tmp.d(i,j) + change
	 			change = 0
	 		endfor
		endfor
; -------------- annotate and return result
	tmp.dl = tmp.dl + ' FixR'
	return, tmp
END
