; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	GET_TEXT 
; 
;LAST CHANGED: ----------------------------------- 27-feb-00 
; 
;PURPOSE: 
;	This function is a pop-up widget that 
; allows user to input one string of text 
; 
;CATEGORY: 
;	AXIS: utility (operates as stand alone) 
; 
;CALLING SEQUENCE: 
;	Result = GET_TEXT(Prompt = prompt, Value = value, group = AxisID) 
; 
;CALLED FROM AXIS: 
;	many routines 
; 
;ROUTINES 
;	TEXT_EVENT, event - event processing procedure 
;	GET_TEXT - the widget code 
; 
;INPUTS: none 
; 
;KEYWORDS: 
;	PROMPT - title at top of widget 
;	VAL - default value of the text string 
;	group - group ID of caller 
; 
;OUTPUTS: 
;	The string is returned and the widget destroyd. 
 
;COMMON BLOCKS: 
;	TXTCOM, txt 
; 
;MODIFICATION HISTORY: 
; (19-Jun-97 aph) created 
; (05-jul-98 aph) made it return string not string array ! 
; (13-dec-98 aph) make it work with IDL 5.2; VALUE needed to be defined(!) 
; (20-dec-98 aph) allow scrolling; append; customize for IDL5.1 (Array-2); IDL4.0(array-1) 
; (08-jan-99 aph) error when txt returns only 1 entry 
; (27-feb-00 aph) AXIS standard documentation; remove modal call to xmanager 
;- 
 
PRO TEXT_Event, Event 
 
Common TXTCOM, txt 
on_error,2 
WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev 
CASE Ev OF 
  'TEXT2': BEGIN 
   	 WIDGET_CONTROL, Event.Id, GET_VALUE = txt 
   	 WIDGET_CONTROL, Event.Top, /DESTROY 
      END 
  ENDCASE 
END 
 
FUNCTION get_text, VAL=val, PROMPT = prompt, GROUP=Group 
Common TXTCOM, txt 
on_error,2 
 
junk   = { CW_PDMENU_S, flags:0, name:'' } 
 
modal_val=1 
IF N_ELEMENTS(Group) EQ 0 THEN begin 
;  	test_valid = widget_event(AXIS, bad_id=bad_id) ;, FIND_BY_UNAME = 'AXIS') 
;  	print, 'test_valid',test_valid 
;	if group EQ 0 then				; attempt to auto-test if in AXIS - no go yet 
group=0 
modal_val=0 
ENDIF 
 
IF keyword_set(prompt) THEN prompt_text = prompt ELSE prompt_text = ' ' 
 
TEXT = WIDGET_BASE(GROUP_LEADER=Group, $ 
  ALIGN_CENTER = 1, $ 
  ROW=2, $ 
  modal = modal_val, $ 
  TITLE='get_text', $ 
  UVALUE='TEXT') ;, $ 
  ;XOFFSET = 200, $ 
  ;YOFFSET = 50) 
 
LABEL2 = WIDGET_LABEL( TEXT, $ 
      UVALUE='prompt', $ 
      VALUE=prompt_text) 
 
IF NOT KEYWORD_SET(VAL) then val=' ' 
TEXT2 = WIDGET_TEXT( TEXT,VALUE=val, $ 
  XSIZE = 30, $ 
  EDITABLE=1, $ 
  UVALUE='TEXT2', $ 
  YSIZE=1) 
 
 
WIDGET_CONTROL, TEXT, /REALIZE 
WIDGET_CONTROL, TEXT2, /INPUT_FOCUS 
XMANAGER, 'TEXT', TEXT 
 
IF n_elements(txt) GT 1 then begin 
  tt = txt(0) + txt (1)          ; switch for IDL 5 - if old and new text present 
ENDIF else tt = txt(0) 
Return, tt 
END 
