; $Id: string2file.pro,v 1.1 1997/06/04 17:42:53 loo Exp $ 
; 
;+ 
; NAME: 
;       STRING2FILE 
; 
; PURPOSE: 
;       This procedure writes the contents of a string array to a text  
;       file, one element per line. 
; 
; CATEGORY: 
;       Input / Output 
; 
; CALLING SEQUENCE: 
;       STRING2FILE, In_string, Filename 
; 
; INPUTS: 
;       In_string: The string array to write to the file. 
; 
;       Filename:  The name of the text file to receive the string data. 
; 
; KEYWORD PARAMETERS: 
;       APPEND:    If set, and if the output file exists, the data is appended 
;                  to the output file. By default, the output file is 
;                  overwritten. 
; 
; OUTPUTS: 
;       None 
; 
; WRITTEN BY: 
;       Billy W. Loo, Jr. 
;       Bioengineering Graduate Group, UCSF / UCB 
;       School of Medicine, UCD 
;       Lawrence Berkeley National Lab 
;       May, 1997 
;- 
; 
; MODIFICATION HISTORY: 
; 
; $Log: string2file.pro,v $ 
; Revision 1.1  1997/06/04 17:42:53  loo 
; Initial revision 
; 
 
PRO STRING2FILE, in_string, filename, APPEND=append 
  ;Open file for writing. 
  OPENW, lun, filename, /GET_LUN, APPEND=KEYWORD_SET(append) 
 
  ;Write contents of string array into file, one element per line. 
  FOR i = 0, N_ELEMENTS(in_string)-1 DO BEGIN 
    PRINTF, lun, in_string(i) 
  ENDFOR 
 
  ;Close file and exit. 
  CLOSE, lun 
  FREE_LUN, lun 
 
  RETURN 
END ;string2file 
