; Copyright (c) 1998-2022 A.P. Hitchcock  All rights reserved
;+
;NAME:  Read_PTY_PIE_stack
;
;
;LAST CHANGED: ----------------------------------- 	22 May 2022 aph)

; PURPOSE:
;	This function reads a set of amplitude or phase images fromPty-PIE reconstruction of spectro ptychography measurements
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
;
;   tmp = READ_PTY_PIE_STACK(parameters)
;
; INPUTS:
;	FILE	filename.
;
; KEYWORDS:
;	KEY1:  none
;
; OUTPUTS:
;  WRITES stack in (ncb, dat) format to disk
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
; (22-May-22 aph) first version
;-

function read_pty_pie_stack, group = group
@axis_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com
on_error, 2

s = 1
; ------- select all files

pty_files = dialog_pickfile(title='Select all files in stack',filter=['*.txt'], /multiple, path=DefPath, get_path=folder_path)
t = ax_name(pty_files(0))
file_path = t(0)
file_ext = t(2)

; -------- filter list into amp and phase filenames
pty_short = strarr(n_elements(pty_files))
for i = 0, n_elements(pty_files)-1 do begin
	t = ax_name(pty_files(i))
	pty_short(i) = t(1)
endfor

; ------- make list of amp and phase file names
pty_amp = pty_short(where(strpos(pty_short, 'amp') GT 0))
pty_phase = pty_short(where(strpos(pty_short, 'phase') GT 0))

n_energy = n_elements(pty_amp)
axis_log, 'stack has ' + strmid(string(n_energy),2) + ' images'

; ----- get user to select amplitude or phase
if widget_info(/active) EQ 0 then query = dialog_message('Amplitude (Yes) or Phase (No)', /question) else $
        query =  dialog_message('Amplitude (Yes) or Phase (No)', dialog_parent=group,  /question)
if query EQ 'No' then amp_phase = 'P' else amp_phase = 'A'

; ------ read first image to get image dimensions; expand since images are different sizes
if amp_phase EQ 'A' then tf = pty_amp(0) else  tf = pty_phase(0)
first_file = file_path + tf + '.' + file_ext
tmp = spc_load(file=first_file, /header, filter='*.txt', group = axis_ID, /silent)
nx = n_elements(tmp.x) + 100
ny = n_elements(tmp.y) + 100

image_stack = fltarr(nx, ny, n_energy)
FILENAME_EV_MSEC_LIST = strarr(n_elements(pty_amp))
ev = fltarr(n_elements(pty_amp))

; -------- read the amplitude images --------
if amp_phase EQ 'A' then n_img =  n_elements(pty_amp)-1 else  n_img = n_elements(pty_phase)-1
 for i = 0, n_img  do begin
 	if amp_phase EQ 'A' then tf = pty_amp(i) else  tf = pty_phase(i)
	next_file = file_path +tf + '.' + file_ext
	axis_log, tf
	tmp = spc_load(file=next_file, /header, filter='*.txt', group = axis_ID, /silent)      ; /silent,
	nxt = n_elements(tmp.x)
	nyt = n_elements(tmp.y)
	image_stack(0:nxt-1,0:nyt-1,i) = tmp.d

	et = strmid(tf,strpos(tf,'_')+1)
	ev(i)= float(strmid(et,0,strpos(et,'eV')))
	FILENAME_EV_MSEC_LIST(i) = tmp.dl + '  ' + string(ev(i))
;	print, FILENAME_EV_MSEC_LIST(i)
endfor
; help, ev
; help, image_stack

; ---- construct  stack file
; ---- generate information needed for stack

x_start= 0 & x_step = 1
y_start= 0 & y_step = 1
x = findgen(nx)  & y = findgen(ny)

x = x_start+ x_step*x
y = y_start+ y_step*y
x_stop = x(nx-1) & y_stop = y(ny-1)

; ---- create stack file

sname=pickfile2(title='Choose name of amplitude stack', file = sname, filter='*.ncb', path = DefPath, lpath=DefPath)

if sname NE '' then  stack_wb, sname, /real

return, sname
END

