pro INFO, s
;-------------
;prints a summary of labview xps data file structure read by loadgen
on_error,2
print,'======='
;help, /struct, s
print,'-------'
print,'File Loaded:',s.fname
print,'# Cycles=',s.summary(1)
ni=s.summary(3)
print,'# Indvars=',ni
if ni gt 0 then for i=0,ni-1 do print,'  ',i,'> ',s.indnames(i)
nd=s.summary(4)
print,'# Single Shots=',nd
if nd gt 0 then for i=0,nd-1 do print,'  ',i+ni,'> ',s.singlenames(i)
nn=s.summary(5)
print,'# Norm. Columns=',nn
if nn gt 0 then for i=0,nn-1 do print,'  ',i+ni+nd,'> ',s.normnames(i)
nr=s.summary(6)
print,'# of spectral regions=',nr
if nr gt 0 then begin
    hasvf=(s.PhiDescr(5) eq 2)
    if hasvf then str='' else str='NO '
    print, str+'V-F data found.'
endif
print,'======='
end
  