; Copyright (c) 2001 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_SHIFT_ALL
;
;LAST CHANGED: ----------------------------------- 7-dec-01
;
; PURPOSE:
;	This procedure uses ax_shift_image to
; rotate and shift a set of images identified by a stack_list file.
; The rotation and shift parameters are read from a file.
; Developed as part fo the 3d chemical mapping suite.
;
; CATEGORY:
;	stand alone ; AXIS: stack analysis
;
; CALLING SEQUENCE:
; ax_shift_all, sl = sl, aln=aln
;
; INPUTS: none
;
;  FORMAT of *.rsl angle shift file
;  path								c:\stxm532\01-11\X1-3d\rotate-iwata\
;  name, angle, xshift, yshift		x1-1r.nc, 0,   18.5000,  -32.5000
; ..... for each file
;
; KEYWORDS:
;	SL  - stack list and lignment parameters (angle, x-shift, y-shift)
;
; OUTPUTS:
;	sl file with names of transformed images - default name is same name with
;  't_' prefix appended
;
; COMMON BLOCKS:
;   none
;
 ; MODIFICATION HISTORY:
; (04-dec-01 aph) first written
; (07-dec-01 aph) add global offsets
;-

pro ax_shift_all, rsl = rsl
@bsif_common

; ------- get file for angle, xshift, yshift if not in call

if not keyword_set(rsl)then begin
	rsl = pickfile2(prompt = 'list of files, angles, shifts', filter = '*.rsl')
	if rsl EQ '' then return
endif
openr, lun, rsl, /get_lun
path = ''
readf, lun, path
print, 'path = ', path
filename_list = strarr(1)
angle = fltarr(1)
xshift = fltarr(1) & yshift = fltarr(1)
dumn='' & duma = 0. & dumx = 0. & dumy = 0.
readf, lun,  dumn  ;, duma, dumx, dumy
comma = strpos(dumn, ',')
filename_list(0) = strmid(dumn, 0, comma)
dumn = strmid(dumn, comma+1)
comma = strpos(dumn, ',')
t = strmid(dumn, 0, comma)
angle(0) = float(t)
dumn = strmid(dumn, comma+1)
comma = strpos(dumn, ',')
xshift(0) =  float(strmid(dumn, 0, comma-1))
dumn = strmid(dumn, comma+1)
comma = strpos(dumn, ',')
yshift(0) =float(dumn)
i = 1
 while not eof(lun) do begin
 	readf, lun, dumn   ;, duma, dumx, dumy
; 	print,  dumn
	filename_list = [filename_list,'string']
	angle  = [angle,0.]
	xshift = [xshift, 0.]
	yshift = [yshift, 0.]
	comma = strpos(dumn, ',')
	filename_list(i) = strmid(dumn, 0, comma)
	dumn = strmid(dumn, comma+1)
	comma = strpos(dumn, ',')
	angle(i) = float(t)
	dumn = strmid(dumn, comma+1)
	comma = strpos(dumn, ',')
	xshift(i) =  float(strmid(dumn, 0, comma-1))
	dumn = strmid(dumn, comma+1)
	yshift(i) =float(dumn)
	i = i + 1
endwhile
close, lun
free_lun, lun
n_files = i

; optional additional global shift
xoffset = 0.  & yoffset = 0.
xoffset = get_num(prompt = 'global X-offset (pixels)', val = xoffset)
yoffset = get_num(prompt = 'global Y-offset (pixels)', val = yoffset)
xs = xshift
ys = yshift
; ----- process this list ---
for i = 0, n_files-1 do begin
	tmp = read_bnl(path+filename_list(i))
	image = tmp.d
	xs(i) = xshift(i)+xoffset
	ys(i) = yshift(i)+yoffset
	new_image = ax_shift_image(image, angle(i), xs(i), ys(i))
	print, 'Processing ', filename_list(i), 'angle = ', angle(i), $
	       ' Xshift = ', xs(i), ' Yshift = ', ys(i)
	tmp.d = new_image
	filename_list(i)= 't_'+filename_list(i)
	q = sav_nsls(tmp, file=path+filename_list(i))
endfor

; -- write out a stack_list
t = ax_name(rsl)
rsl = t(0) + 't_'+t(1) + '.sl'
openw, lun, rsl, get_lun
printf, lun, path
for i = 0, n_files-1 do begin
	printf, lun, filename_list(i)
endfor
close, lun
free_lun, lun

; --- print a summary to the log window for logging
print, ' Translation - rotation of image sequence'
print, '-------------------------------------------------'
print, 'name           angle       X-shift       Y-shift (pixels)'
print, '-------------------------------------------------'
for i = 0, n_files-1 do begin
	print, filename_list(i), angle(i), xs(i), ys(i)
endfor

return

end