
; Copyright (c) 1998-2013 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		GEN_E
;
;LAST CHANGED: ----------------------------------- 	11-Mar-2013
;
; PURPOSE:
;	This function generates a list of energies from start and step
; parameters (Originally developed for read-in of E associated with PEEM stacks from Saga LS)
; assumes the start energies are in INCREASING energy magnitude without repeats or non-monotonic
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:
;	Result = GEN_E(file=file)
;
; INPUTS:none
;
; KEYWORDS:
; 	FILE	if given, the name of the file with the {start, step} list
;
; OUTPUTS: 1-d array of real numbers is returned
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (11-Mar-13 aph) first version
;-

function gen_E, file = file
@axis_com
on_error,2

fltr = '*.txt'
if not keyword_set(file) then $
    file = pickfile2(/read,title='select Energy limits, step file', filter='*.txt')
tmpE = read_ascii(file, count=n_E)
E_limits_step = tmpE.field1
t=size(E_limits_step)
n_region = t(2)
energy = fltarr(1)
energy(0)= E_limits_step(0,0)
np=0
for i = 0, n_region-2 do begin
	while energy(np) LT E_limits_step(0,i+1) do begin
		energy = [energy,0.]
		energy(np+1) = energy(np) + E_limits_step(1,i)
		np = np+1
	endwhile
endfor
; print, energy
return, energy
end