; Copyright (c) 1998-2021 A.P. Hitchcock  All rights reserved
;+
;NAME:  READ_MAXIV_H5
;
;
;LAST CHANGED: ----------------------------------- 	06 Nov 2021

; PURPOSE:
;	This procedure  reads used selected entries from the SoftiMax daily data logging hf file
; First developed to access the  spectra recorded using the beamline photodiode
; during cleaning of M1, M2, grating
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
; RESULT = READ_MAXIV_H(file=file, group=group_ID)
;
; INPUTS: none
;
; KEYWORDS:
;	FILE	filename
;	GROUP	parent.

; OUTPUTS: spectral fime
;
;
; COMMON BLOCKS:
; AXIS_COM    standard set of common blocks


; MODIFICATION HISTORY:
; (06-Nov-21  aph) first version
;-


FUNCTION read_maxIV_h5,file=file, group=group_ID

@axis_com

on_error,2


;  Open the hdf55  (*.h5) container

f=pickfile2(/READ, FILTER='*.h5', /LPATH, DEFPATH=defpath, TITLE = 'Select h5 container')

a=h5_browser(f,/dialog_read)

;  User selects the entry number

entry = a.entry_identifier._data

energy= a.plot_1.beamline_energy._data
signal = a.plot_1.AEM_O04_01_CH1._data

day_time = a.end_time._data
 st=strpos(day_time, 'T')
time=strmid(day_time, st+1, 5)

dl = entry + '     ' +  strmid(day_time, 0,10) + '  HH:MM= ' + time
print, dl

s = {t:'1d', x:energy, d:signal, dn:signal, xl:'Photon energy (eV)', dl: dl}

strput,time,'-',2
print, time

fname = entry + '_' + strmid(day_time, 0,10) + '_' + time  + '.txt'
t = ax_name(f)

t = spc_save(s, file=t(0) + fname)
print, 'wrote entry ', entry, ' to ', fname

return, s
end
