; Copyright (c) 1998-2019 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_INI_SAVE
;
;LAST CHANGED: ----------------------------------- 26-Jun-19 (aph)
;
;PURPOSE:
;	This function  writes paramaters defining how aXis2000 opeates to a file
; 'axis.ini' in the CodePath folder
;
;CATEGORY:
;	AXIS: utility (captive
;
;CALLING SEQUENCE:
;;   test = AXIS_INI_SAVE (filename = filname)
;
;CALLED FROM AXIS:
;  at  Quit
;
;INPUTS: none
;
;KEYWORDS:
;	FILENAME - initialization file name (optional)
;
;OUTPUTS:
;	on Windows OS  axis_win.ini  (or user defined file name)
; on Unix    OS  axis_unix.ini (or user defined file name)
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
; on exit from AXIS writes out default values
;
;MODIFICATION HISTORY:
; (28-jun-98 aph) first version
; (12-dec-98 aph) introduce font switching for widget (to adapt IDL 4, IDL 5)
; (13-dec-98 aph) add /set option
; (29-dec-98 aph) use AXIS_OPTIONS to establish defaults (IDL 5.2)
; (03-Jan-99 aph) set default WIN font to Arial*14; switch on 5.2 NOT 5
; (11-May-99 aph) establish axis_ini_save subroutine;
;				  allowed 'Printer' to be full command line, not just language
; (24-may-99 aph) extend to include HELP file command
; (16-nov-99 aph) 'loc' -> 'location' to see if this is why it is not preserved
; (02-jan-00 aph) AXIS standard documentation
; (31-jan-00 aph) add  net browser command
; (27-feb-00 aph) add groupID to get_text
; (07-apr-00 aph) modify to force saving to codepath area by passing on file to axis_ini_save
; (30-nov-00 cgz) added statements to ensure that no leading or trailing spaces are
;				included in parameters once read in from *.ini file
; (05-dec-00 cgz) reversed order of AXIS_INI and AXIS_INI_SAVE
; (09-dec-00 cgz) added conversion of float(strtrim(gr_scale,2))
; (23-jan-01 cgz) added dialog to axis_ini_save, also cleaned up logical path
; (31-jan-01 aph) change prompt
; (22-apr-01 aph) fix crash when load using axis.ini from separate directory - drop axis_options
; (07-oct-01 aph) re-activate axis_options
; (28-oct-04 aph) allow for rescue if user pushes 'cancel' on 'exit'
; (08-nov-04 aph) fix problem that axis2000 does NOT use saved last_file / path information
;            problem was LPath not DefPath was saved, but previously it worked; probably was change in axis_ini_save
; (24-jan-05 aph) replace test for read-in which failed in IDL5.2
; (11-Jan-10 aph) put this code into a separate axis_ini_save.pro file (isolated from from axis_ini.pro)
; (19-Nov-11 aph) automatically save to default file & location, but ask if cannot find it
; (18-Aug-12 aph) get to work on both Mac and Win versions
; (21-Jul-14 aph) save last file name as well as path
; (30-Nov-14 aph) make print both folder (DefPath) and last filename (lfile) ==> REMOVED 2-Aug-15 (did not work right)
; (24-Jul-15 aph) change to write different files for Windows and Unix
; (02-Aug-15 aph) sort out why Zimba (zstack_analyze) does not write path
; (19-Mar-16 aph) get working with MacOS
; (26-Jun-19 aph)  update text to reflect current initialization file content (NB defaults set in axis_ini.pro)
;-

FUNCTION axis_ini_save, filename = filename
@axis_com
@sdf_com

get_lun,iunit
on_ioerror, axis_ini_save_oops

IF NOT keyword_set(filename) then begin
  if !version.os_family EQ 'Windows' then filename = 'axis_win.ini'  ; force name to be this on Windows OS
  if !version.os_family EQ 'unix' then filename = 'axis_unix.ini'  ; force name to be this Unix OS (includes Mac OS X)
ENDIF
axis_log, 'Saving aXis2000 parameters to ' + CodePath + filename

; ---- find the folder where aXis2000 is presently working
cd, current=current_directory
; print, 'current directory is ', current_directory
; print, 'DefPath is ', DefPath
; print, 'Lpath is ', Lpath
; heirarchy is Lpath > DefPath > current_directory
if strtrim(DefPath,2) NE '' then DefPath = current_directory + ax_sep()
if strtrim(LPath,2) NE '' then DefPath = Lpath ; save DefPath or the LASTPATH from file reading
; print, 'after checks'
; print, 'DefPath is ', DefPath
; print, 'Lpath is ', Lpath


; -------- force path for writing the initialization file to be the CodePath -----
; CodePath=''
	IF n_elements(CodePath) GT 0 then begin
		t=ax_name(filename)
		filename = CodePath + t(1) + '.' + t(2)
	ENDIF ELSE BEGIN     ; if CodePath is not defined for some reason
	; ask user to navigate to the codepath to get correct folder string
	   filename = dialog_pickfile(filter='*.ini', /write, /fix_filter, $
                   file=filename, path=CodePath, get_path=CodePath, $
                   title='Please identify the file "axis.ini" in the CodePath folder  :')
       if filename NE '' then begin
       		t = ax_name(filename)  & CodePath = t(0)
       		print, 'CodePath identified as: ', Codepath
       ENDIF
	ENDELSE

; --------- check if ini_file actually exists (could be bad from wrong axis.ini  file)
  print, 'Checking for existence of file ', filename
	test = findfile(filename,count=ctest)
	IF ctest EQ 0 then BEGIN
	  axis_log, 'Cannot find aXis2000 source folder  - please locate manually'
		filename = dialog_pickfile(filter='*.ini', /write, /fix_filter, $
			file=filename, path=CodePath, get_path=CodePath, $
			title='Save aXis2000 initialization file as :')
		IF (filename EQ '') THEN BEGIN
			data_directory = current_directory
			GOTO, axis_ini_save_oops 	; trap if CANCEL is chosen in dialog
		ENDIF
 	ENDIF


openw,iunit,filename

on_ioerror, axis_ini_save_oops

printf, iunit, CodePath
printf, iunit, Gr_Dev
printf, iunit, Print_Dev
printf, iunit, DefPath
printf, iunit, strcompress(string(gr_scale))
printf, iunit, strcompress(string(ColTbl))
printf, iunit, location
printf, iunit, Print_file
printf, iunit, BufLblFont
printf, iunit, PR_command
printf, iunit, Help_cmd
printf, iunit, Net_command
dt = systime()
printf, iunit, '---------------------------------- '
printf, iunit, 'written: ', dt
printf, iunit, ' '

; --------- print trailer to help users define themselves
printf, iunit, '; ********** Initialization file for AXIS Widget *******************'
printf, iunit, '; '
printf, iunit, '; (aph 30-Nov-14)  Please adapt to your hardware '
printf, iunit, '; Items set                    devices currently supported  '
printf, iunit, '; ---------------------------  -------------------- '
if !version.os_family EQ 'Windows' then $
    printf, iunit, '0 CodePath                  (e.g. c:\axis2000\) - include final separator'
if !version.os_family EQ 'unix' then $
  printf, iunit, '0 CodePath                  (e.g.  /Users/aph/aXis2000-8.3/) - include final separator'
printf, iunit, '1 Screen display device     (WIN, X)  '
printf, iunit, '2 Print file format		    (PCL, PS) '
printf, iunit, '3 Last data file read/wrote  saved on exit of aXis2000  '
printf, iunit, '4 graphics scale factor     (0.5 - 2) (1 = 360x360 pixels for main display)  '
printf, iunit, '5 color table               (any IDL supports) 0 = B/W; 3 = red temperature '
printf, iunit, '6 location                  (NOT USED. NSLS has special meaning = spooler switch) '
printf, iunit, '7 spooler or print file     (OBSOLETE) '
printf, iunit, '8 default font for widget   (OBSOLETE; windows - Arial*14; unix - 6x10 or 8x13 ) '
printf, iunit, '9 Printer command line      (OBSOLETE)'
if !version.os_family EQ 'Windows' then $
  printf, iunit,'10 Command to view Help pdf  (get acrobat reader free from www.adobe.com)'
if !version.os_family EQ 'unix' then $
  printf, iunit,'10 Command to view Help pdf  (e.g."/Applications/Preview")'
if !version.os_family EQ 'Windows' then $
    printf, iunit,'11 command to run browser   (e.g."C:\Program Files (x86)\Google\Chrome\Application\chrome.exe")'
 if !version.os_family EQ 'unix' then $
    printf, iunit,'11 command to run browser   (e..g  (unix system command to start Chrome] )'
printf, iunit, ' '
printf, iunit, ' Printing now done exclusively by passing to operating system printer'
printf, iunit, ' '
printf, iunit, ' to allow aXis2000 splash screen links to XRM facility websites, and the aXis2000 site'
printf, iunit, '     line 11 l must be the system command line text which opens a Browser
printf, iunit,' '

print,'Wrote AXIS parameters as a file "'+filename+'"'

close,iunit
free_lun,iunit
return, filename

axis_ini_save_oops :
	text = 'Saving aXis2000 parameter file (axis.ini) was unsuccessful. Aborting exit'
	print, text
	WIDGET_CONTROL, Uprompt, SET_VALUE=text
	test = ''
	close,iunit
	free_lun,iunit
	return, test
end
