;; This routine sets stray clock values to the average for
;; a column.  CJJ, 30 Nov. 1999
;; Slight modifications: CJJ, 22-May-2001
;;
PRO sm_fixclock,image_data,i_clock,help=help
  
  IF (keyword_set(help) OR (n_params() EQ 0)) THEN BEGIN
      print,'sm_fixclock,image_data,i_clock'
      return
  ENDIF
  
  clock_tolerance = 0.1
  
  svec = size(image_data)
  IF (svec(0) NE 3) THEN BEGIN
      message,'expected image_data(n_cols,n_rows,n_data)'
  ENDIF ELSE BEGIN
      n_cols = svec(1)
      n_rows = svec(2)
      n_data = svec(3)
      clock_image = reform(image_data(*,*,i_clock),n_cols,n_rows)
      
      FOR i_col=0,(n_cols-1) DO BEGIN
          clock_column = clock_image(i_col,*)
          clock_median = median(clock_column)
          toobig = where(clock_column GT $
                         ((1.+clock_tolerance)*clock_median), n_toobig)
          IF (n_toobig NE 0) THEN BEGIN
              clock_column(toobig) = clock_median
          ENDIF
          toosmall = where(clock_column LT $
                           ((1.-clock_tolerance)*clock_median), n_toosmall)
          IF (n_toosmall NE 0) THEN BEGIN
              clock_column(toosmall) = clock_median
          ENDIF
          clock_image(i_col,*) = clock_column
      ENDFOR
      image_data(*,*,i_clock) = clock_image
  ENDELSE
  
  return
END

