; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_INI
;
;LAST CHANGED: ----------------------------------- 20-Mar-16 (aph)
;
;PURPOSE:
;	This function reads and manages writing a file 
;	which has default values for various aXis2000 parameters 
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	test = AXIS_INI(file=file, out=out, set = set)
;
;CALLED FROM AXIS:
; at start up and Quit
;
;INPUTS: none
;
;KEYWORDS:
;	FILE - initialization file name
;	/OUT - write initialization file
;	/SET - interactive setting of default values
;
;OUTPUTS:
;	axis.ini (or user defined file name)
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
; looks up  default values from AXIS.INI or a user-defined file
; if no file, establish defaults
; on exit from AXIS writes out default values to AXIS.INI or a user-specified file
;
;MODIFICATION HISTORY:
; (28-jun-98 aph) first version
; (12-dec-98 aph) introduce font switching for widget (to adapt IDL 4, IDL 5)
; (13-dec-98 aph) add /set option
; (29-dec-98 aph) use AXIS_OPTIONS to establish defaults (IDL 5.2)
; (03-Jan-99 aph) set default WIN font to Arial*14; switch on 5.2 NOT 5
; (11-May-99 aph) establish axis_ini_save subroutine;
;				  allowed 'Printer' to be full command line, not just language
; (24-may-99 aph) extend to include HELP file command
; (16-nov-99 aph) 'loc' -> 'location' to see if this is why it is not preserved
; (02-jan-00 aph) AXIS standard documentation
; (31-jan-00 aph) add  net browser command
; (27-feb-00 aph) add groupID to get_text
; (07-apr-00 aph) modify to force saving to codepath area by passing on file to axis_ini_save
; (30-nov-00 cgz) added statements to ensure that no leading or trailing spaces are
;				included in parameters once read in from *.ini file
; (05-dec-00 cgz) reversed order of AXIS_INI and AXIS_INI_SAVE
; (09-dec-00 cgz) added conversion of float(strtrim(gr_scale,2))
; (23-jan-01 cgz) added dialog to axis_ini_save, also cleaned up logical path
; (31-jan-01 aph) change prompt
; (22-apr-01 aph) fix crash when load using axis.ini from separate directory - drop axis_options
; (07-oct-01 aph) re-activate axis_options
; (28-oct-04 aph) allow for rescue if user pushes 'cancel' on 'exit'
; (08-nov-04 aph) fix problem that axis2000 does NOT use saved last_file / path information
;            problem was LPath not DefPath was saved, but previously it worked; probably was change in axis_ini_save
; (24-jan-05 aph) replace test for read-in which failed in IDL5.2
; (11-Jan-10 aph) removed the  axis_ini_save code to its own pro file (isolated axis_ini.pro)
; (19-Nov-11 aph) automatically save to default axis.ini file location, but ask if cannot find it
; (21-Jul-14 aph) save last file name, not just last path
; (30-Nov-14 aph) ensure last filename saved (was not working from July 2014 change)
; (24-Jul-15 aph) write axis_win.ini or axis_unix.ini depending on the operating system ( !version.os_family )
; (20-Mar-16 aph) get working with MacOS
;-

FUNCTION AXIS_INI, file=file, out=out, set = set, _extra_e
@axis_com
@sdf_com

on_error,2

test = ''

if keyword_set(set) then begin
; -------------- DEFINE PARAMETERS FROM SCRATCH ------------------------ 
  if !version.os_family EQ 'Windows' then begin
    print, ' Windows: Please open the text file axis_win.ini'
    print, 'in the aXis2000 source folder and modify to suit your environment'
    return, test
  endif else begin
    print, ' UNIX: Please open the text file axis_unix.ini'
    print, 'in the aXis2000 source folder and modify to suit your environment'
        return, test
  endelse
endif


; --------- WRITE CURRENT DEFAULT VALUES --------------------
if keyword_set(out) then begin
	 if keyword_set(file) then test = axis_ini_save(filename=file) else test = axis_ini_save()

; ------- READ CURRENT DEFAULT VALUES --------------------
endif else BEGIN	; ASSUMES ONLY 2 actions - write or read !!

;--------- predefine defaults (this is needed to set data types even if they will be replaced) etc -----------
  	if !version.os_family EQ 'Windows' then begin
  	   LPath = ''
  	   CodePath = 'c:\aXis2000\'
  	   gr_dev = 'WIN'
  	   Print_Dev = 'PS'
  	   DefPath='c:\axis2000'
  	   gr_scale=1.0
  	   ColTbl = 0
  	   location = 'mac'				; location - to allow switching location specific code
  	   Print_file = 'idl.ps'	; default print file name (postscript)
  	   BufLblFont = 'Arial*14'  ; default font
  	   PR_Command = 'copy idl.win lpt1:'  ; command to transfer file to printer
  	   Help_cmd = 'c:\progra~1\acrobat3\reader\acroRd32 c:\axis\axis.pdf'   ; bl7-dow command to spawn to view HELP file
  	   Net_command = 'c:\progra~1\netscape\communicator\program\netscape'
  	endif else begin
  	   LPath = '' 				; ASSUMES alternate system is unix (Mac OS X, or linix or ...)
  	   CodePath = '/Users/aXis2000/aXis2000-code/'
  	   gr_dev = 'X'
  	   Print_Dev = 'PS'
  	   DefPath='/Users/aXis2000/aXis2000-code/'
  	   gr_scale=1.2
  	   ColTbl = 0
  	   location = 'ALS'				; location - to allow switching location specific code
  	   Print_file = 'idl.win'	; default print file name (postscript)
  	   BufLblFont = '6x10'   	; default font
  	   PR_Command = 'lpr ' ; command to transfer file to printer
  	   Help_cmd = '/Users/aXis2000/aXis2000-code/axis.pdf'   ; command to spawn to view HELP file
  	   Net_command = 'safari'
  	endelse

; check for existing ini file  -----
    if !version.os_family EQ 'Windows' then begin
    	  ini_file = file_Search('axis_win.ini', /fully_qualify_path)
    	  if  strlen(ini_file) EQ 0 then  ini_file = file_Search('axis.ini', /fully_qualify_path)
    	  if  strlen(ini_file) EQ 0 then begin
    	    print, 'Cannot find either axis.ini or axis_win.ini files'
    	    print, 'define path to folder with the aXis2000 code in IDL preferences and try again'
    	    return, test
    	  endif
  	  t = ax_name(ini_file)
  	  CodePath=t(0)
     endif else begin    ; for  unix systems
    	  ini_file = file_Search('axis_unix.ini', /fully_qualify_path)
    	  if  strlen(ini_file) EQ 0 then begin
    	    print, 'Cannot find axis_unix.ini file'
    	    print, 'define path to folder with the aXis2000 code in IDL preferences and try again'
    	    return, test
    	  endif
    	  t = ax_name(ini_file)
    	  CodePath=t(0)
  	endelse
	
	; ------ force read-in file from new names
;	if !version.os_family EQ 'Windows' then filename = CodePath + 'axis_win.ini'
;	if !version.os_family EQ 'unix' then filename = CodePath + 'axis_unix.ini'
;	if keyword_set(file) then filename = file

    test = findfile(ini_file,count=ctest)
    if ctest NE 0 then BEGIN
  ; ---------- get defaults from AXIS.ini file -----------------
  		openr,iunit,ini_file,/get_lun
    	readf, iunit, CodePath
  		readf, iunit, Gr_Dev
  		readf, iunit, Print_Dev
  		readf, iunit, DefPath
  		readf, iunit, gr_scale
  		readf, iunit, ColTbl
  		readf, iunit, location
  		readf, iunit, Print_file
  		readf, iunit, BufLblFont
  		readf, iunit, Pr_Command
  		readf, iunit, Help_cmd
  		readf, iunit, Net_command
  		print, 'Initialization info taken from ', ini_file
  		close, iunit
  		CodePath = strtrim(CodePath,2)
  		Gr_Dev = strtrim(Gr_Dev,2)
  		Print_Dev = strtrim(Print_Dev,2)
  		DefPath = strtrim(DefPath,2)
  		gr_scale = float(strtrim(gr_scale,2))
  		ColTbl = strtrim(ColTbl,2)
  		location = strtrim(location,2)
  		Print_file = strtrim(Print_file,2)
  		BufLblFont = strtrim(BufLblFont,2)
  		Pr_Command = strtrim(Pr_Command,2)
  		Help_cmd = strtrim(Help_cmd,2)
  		Net_command = strtrim(Net_command,2)
    endif 
  
   
;----- go get them ! ---- THIS WAS PRESENT PRIOR TO 24-July-2015 BUT NEVER WORKED -----
; THE axis_options WINDGET WAS SUPPOSED TO MAKE THIS EASY FOR USERS BUT IT IS NOT WORKING (24-Jul-2015)
;  			print,'Choose subdirectory containing AXIS code - any filename is OK'
;  			CodePath = pickfile2(/read,filter='*.pro')
;	    	if !VERSION.OS_FAMILY EQ 'unix' then sep = '/' else sep = '\'
;	    	sep_pos = rstrpos(codepath,sep)
;	    	CodePath = strmid(codepath,0,sep_pos+1)
;  			print, ' Select the location and name of the file to save AXIS default paramaters'
;  	    ini_file = pickfile2(/write,filter='*.ini')
;  			Gr_dev = get_text(prompt='Disp (X, WIN)',VAL=Gr_dev, group = axis_ID)	
;			  Print_dev = get_text(prompt='Print (PS, PCL) or command line',VAL=Print_dev)
;	    	Gr_scale = float(get_num(prompt='size(0.5-2)',VAL=Gr_scale))
;			  location = get_text(prompt='location',VAL=location, group = axis_ID)
;		    ColTbl = fix(get_num(prompt='Color Table',VAL=ColTbl))
;			  print,'Choose initial directory for data'
;	    	first = pickfile2(filter='*.*', /lpath)
;	    	if !VERSION.OS_FAMILY EQ 'unix' then sep = '/' else sep = '\'
;	    	sep_pos = rstrpos(first,sep)
;	    	DefPath = strmid(first,0,sep_pos)
;	    	print, 'Default font (WIN = Arial*14, X = 6x10 (Unix))'
;	    	BufLblFont = get_text(prompt='Font',VAL=BufLblFont, group = axis_ID)
;    		print, 'Give command line needed to transfer file to printer'
;    		PR_Command = get_text(prompt= 'Printer command', VAL=PR_Command, group = axis_ID)
;    		Help_cmd = get_text(prompt= 'Help command', VAL=Help_cmd, group = axis_ID)
;    		Net_command = get_text(prompt= 'Net_command', VAL=Net_command, group = axis_ID)
; ------------ store these in new (default) *.ini file --------------------
;			test = axis_ini_save()
			
; -------- call widget to let user define all parameters in the axis.ini fole
; ****** April 2001 - this is NOT working so just print a messge --
   ; 			if !VERSION.OS_FAMILY EQ 'Windows' then begin
   ; 				axis_options
   ; 			 endif else begin
   ; 				print, ' Please open the text file axis.ini and modify to suit your environment'
   ; 			 endelse
   ; 	ENDELSE
;			if keyword_set(set) then WIDGET_CONTROL, UPROMPT, SET_VALUE="Restart Axis for the changes to take effect."
endelse

; ------------------- REPORT TO USER THE CURRENT VALUES -----------------
 if strlen(test(0)) NE 0 then begin  	; only print if the ini file has been written or read
      print, ' '
    	print, 'Ini_file = ',ini_file
    	print, 'CodePath = ', CodePath
    	print, 'Graphics device = ', gr_dev
    	print, 'Printer device/command = ', Print_Dev
    	print, 'Last data file read/wrote = ', DefPath
    	print, 'Graphics scale factor = ', strcompress(string(gr_scale))
    	print, 'Initial color table = ', strcompress(string(ColTbl))
    	print, 'Location = ', location
    	print, 'Print file (or spooler) name = ', Print_file
    	print, 'Font for buffer labels = ', BufLblFont
    	print, 'Printer command line = ', Pr_command
    	print, 'Help command line = ', Help_cmd
    	print, 'Net command line = ', Net_command
    	print, '______________________________________________________ '
    	LPath = DefPath		; bring back last path used when running AXIS
    	WritePath=DefPath
  endif else axis_log, 'Unsuccessful read or write of initialization file'

return, test
end

