; Copyright (c) 1998-2018 A.P. Hitchcock  All rights reserved
;+
;NAME: AX_CONC_CALC.PRO
;
;
;LAST CHANGED: ----------------------------------- 	04 Jun 2018

; PURPOSE:
;	This procedure calculates conentrations of aqueous solution
;   for a given solute (d,MWt) solid solute thickness, and water thickness
;
; CATEGORY:
;	    Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:  ; AX_CONC_CALC
;
; INPUTS: none
;
; KEYWORDS: none
;
; OUTPUTS: none
;
; COMMON BLOCKS:
; @AXIS_COM    standard set of common blocks
; @AX_CONC_CALC_COM  - last set of parameters
;
; AX_CONC_CALC ROUTINES:
; TEXT_SOLUTE_THICKNESS
; TEXT_SOLUTE_DENSITY
; TEXT_SOLUTE_MOL_WEIGHT
; TEXT_WATER_THICKNESS
; BUTTON_DISMISS
; AX_CONC_CALC_event
; AX_CONC_CALC

; MODIFICATION HISTORY:
; (01-Jun-18 aph) first version
;-

;-----------------------------------------------------------------
pro UPDATE_CONC, Event
on_error,2
@axis_com
@ax_conc_calc_com

conc = solute_t*solute_d/(solute_mw*water_t/1000.)
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_CONCENTRATION')
WIDGET_CONTROL,id, Sensitive=1, Set_value = string(conc)
end

;-----------------------------------------------------------------
pro UPDATE_THICKNESS, Event
on_error,2
@axis_com
@ax_conc_calc_com

solute_t = (conc*solute_mw*water_t/1000.)/solute_d
print, 'New solute thickness (nm)', solute_t
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_SOLUTE_THICKNESS')
WIDGET_CONTROL,id, Sensitive=1, Set_value = string(solute_t)
end

;-----------------------------------------------------------------
pro TEXT_CONCENTRATION, Event
on_error,2
@axis_com
@ax_conc_calc_com

; get the changed value
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_CONCENTRATION')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
conc = float(tmp)
print, 'New concentration (mol/L)', conc
end

;-----------------------------------------------------------------
pro TEXT_SOLUTE_THICKNESS, Event
on_error,2
@axis_com
@ax_conc_calc_com

; get the changed value
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_SOLUTE_THICKNESS')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
solute_t = float(tmp)
print, 'New solute thickness (nm)', solute_t
end

;-----------------------------------------------------------------
pro TEXT_SOLUTE_DENSITY, Event
on_error,2
@axis_com
@ax_conc_calc_com

; get the changed value
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_SOLUTE_DENSITY')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
solute_d = float(tmp)
print, 'New solute density (g/cm^3)', solute_d
end

;-----------------------------------------------------------------
pro TEXT_SOLUTE_MOL_WEIGHT, Event
on_error,2
@axis_com
@ax_conc_calc_com

; get the changed value
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_SOLUTE_MOL_WEIGHT')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
solute_mw = float(tmp)
print, 'New solute Molecular Weight (g/mol)', solute_mw
end


;-----------------------------------------------------------------
pro TEXT_WATER_THICKNESS, Event
on_error,2
@axis_com
@ax_conc_calc_com

; get the changed value
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_WATER_THICKNESS')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
water_t = float(tmp)
print, 'New water thickness (nm)', water_t
end

;-----------------------------------------------------------------
pro BUTTON_DISMISS, Event
on_error,2
@axis_com
@ax_conc_calc_com

WIDGET_CONTROL, Event.Top, /DESTROY
return
end

;-----------------------------------------------------------------
pro BUTTON_MW_CALCULATOR, Event
on_error,2
@axis_com
@ax_conc_calc_com
print, 'launching MW calculator: www.lenntech.com/calculators/molecular/molecular-weight-calculator.htm'
spawn, 'c:\Program Files (x86)\Google\Chrome\Application\chrome.exe www.lenntech.com/calculators/molecular/molecular-weight-calculator.htm', /noshell , /nowait
return
end

; ***********************************************************************
pro AX_CONC_CALC_BASE_event, Event
on_error,2
@axis_com
@ax_conc_calc_com

  wTarget = (widget_info(Event.id,/NAME) eq 'TREE' ?  $
      widget_info(Event.id, /tree_root) : event.id)

;help, Event, /struct
;print, 'Event.top ', Event.top
  wWidget =  Event.top
;  help, wWidget
  case wTarget of

;  case Event.id of

    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_CONCENTRATION'): begin
    TEXT_CONCENTRATION, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_SOLUTE_THICKNESS'): begin
    TEXT_SOLUTE_THICKNESS, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_SOLUTE_DENSITY'): begin
    TEXT_SOLUTE_DENSITY, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_WATER_THICKNESS'): begin
    TEXT_WATER_THICKNESS, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_SOLUTE_MOL_WEIGHT'): begin
    TEXT_SOLUTE_MOL_WEIGHT, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_UPDATE_CONC'): begin
    UPDATE_CONC, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_UPDATE_SOLUTE_THICKNESS'): begin
    UPDATE_THICKNESS, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_DISMISS'): begin
    BUTTON_DISMISS, Event
    end
        Widget_Info(wWidget, FIND_BY_UNAME='BUTTON_MW_CALCULATOR'): begin
    BUTTON_MW_CALCULATOR, Event
    end

    else:
  endcase

end

pro AX_CONC_CALC, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
on_error,2
@axis_com
@ax_conc_calc_com

  AX_CONC_CALC_BASE = Widget_Base( GROUP_LEADER=wGroup, UNAME='AX_CONC_CALC_BASE'  $
      ,SCR_XSIZE=500 ,SCR_YSIZE=210, XOFFSET=5 ,YOFFSET=5 ,  $
      TITLE='Aqueous solution concentration calculator' ,SPACE=3 ,XPAD=3 ,YPAD=3)

  WID_TEXT_CONCENTRATION = Widget_Text(AX_CONC_CALC_BASE,  $
      UNAME='WID_TEXT_CONCENTRATION'  ,SCR_XSIZE=90 $
      ,XOFFSET=25 ,YOFFSET=70,/EDITABLE)
  WID_Label_conc = Widget_Label(AX_CONC_CALC_BASE, UNAME=' WID_Label_conc'   $
      ,XOFFSET=15,YOFFSET=50, Value = 'Concentration (mol/L)')

  WID_LABEL_0 = Widget_Label(AX_CONC_CALC_BASE, UNAME='WID_LABEL_0'  $
      ,XOFFSET=140 ,YOFFSET=70 ,/ALIGN_LEFT ,VALUE='=')

  WID_TEXT_SOLUTE_THICKNESS = Widget_Text(AX_CONC_CALC_BASE,  $
      UNAME='WID_TEXT_SOLUTE_THICKNESS' ,XOFFSET=160 ,YOFFSET=55,/EDITABLE)
  WID_Label_solute_t = Widget_Label(AX_CONC_CALC_BASE, UNAME='WID_Label_solute_t', $
       XOFFSET=170 ,YOFFSET=40, VALUE='Solute thickness (nm)')

  WID_LABEL_1 = Widget_Label(AX_CONC_CALC_BASE, UNAME='WID_LABEL_1'  $
      ,XOFFSET=295 ,YOFFSET=60 ,/ALIGN_LEFT ,VALUE='x')

  WID_TEXT_SOLUTE_DENSITY = Widget_Text(AX_CONC_CALC_BASE,  $
      UNAME='WID_TEXT_SOLUTE_DENSITY' ,XOFFSET=320 ,YOFFSET=55, /EDITABLE)
  WID_Label_Solute_d = Widget_Label(AX_CONC_CALC_BASE,  $
      UNAME='WID_Label_Solute_d' ,XOFFSET=320, YOFFSET=40,Value = 'Solute density (g/cc)')

  WID_LABEL_2 = Widget_Label(AX_CONC_CALC_BASE, UNAME='WID_LABEL_2'  $
      ,XOFFSET=160 ,YOFFSET=70 ,SCR_XSIZE=355 ,SCR_YSIZE=15,/ALIGN_LEFT  $
      ,VALUE='___________________________________________________')

  WID_TEXT_SOLUTE_MOL_Weight = Widget_Text(AX_CONC_CALC_BASE,  $
      UNAME='WID_TEXT_SOLUTE_MOL_WEIGHT' ,XOFFSET=160, YOFFSET=90, /EDITABLE)
  WID_Label_Solute_MW = Widget_Label(AX_CONC_CALC_BASE,  $
      UNAME='WID_Label_Solute_MW' ,XOFFSET=150, YOFFSET=115, Value= 'Solute molecular weight (g/mol)')

  WID_LABEL_3 = Widget_Label(AX_CONC_CALC_BASE, UNAME='WID_LABEL_3'  $
      ,XOFFSET=295,YOFFSET=95 ,/ALIGN_LEFT ,VALUE='x')

  WID_TEXT_WATER_THICKNESS = Widget_Text(AX_CONC_CALC_BASE,  $
      UNAME='WID_TEXT_WATER_THICKNESS' ,XOFFSET=320 ,YOFFSET=90,/EDITABLE)
  WID_Label_water_t = Widget_Label(AX_CONC_CALC_BASE,  $
      UNAME='WID_TEXT_WATER_THICKNESS_LBL' ,XOFFSET=320 ,YOFFSET=115, Value = 'Water thickness (nm)')

  WID_BUTTON_DISMISS = Widget_Button(AX_CONC_CALC_BASE,  $
      UNAME='WID_BUTTON_UPDATE_CONC' ,XOFFSET=15 ,YOFFSET=2  $
      ,SCR_XSIZE=120, SCR_YSIZE=30 ,/ALIGN_LEFT,VALUE='Update concentration')

  WID_BUTTON_DISMISS = Widget_Button(AX_CONC_CALC_BASE,  $
      UNAME='WID_BUTTON_UPDATE_SOLUTE_THICKNESS' ,XOFFSET=160,YOFFSET=2  $
      ,SCR_XSIZE=130 ,SCR_YSIZE=30 ,/ALIGN_LEFT ,VALUE='Update solute thickness')

  WID_BUTTON_DISMISS = Widget_Button(AX_CONC_CALC_BASE,  $
      UNAME='WID_BUTTON_DISMISS' ,XOFFSET=15 ,YOFFSET=105  $
      ,SCR_XSIZE=80 ,SCR_YSIZE=30 ,/ALIGN_CENTER ,VALUE='Dismiss')

 WID_LABEL_2 = Widget_Button(AX_CONC_CALC_BASE, UNAME='BUTTON_MW_CALCULATOR'  $
      ,XOFFSET=150 ,YOFFSET=140,SCR_YSIZE=25, /ALIGN_LEFT  $
      ,VALUE='Molecular weightcalculator')



; --- set intial value to stored, or default
	if n_elements(solute_t) EQ 0 then solute_t=10.
	if n_elements(solute_d) EQ 0 then solute_d=2.
	if n_elements(solute_mw) EQ 0 then solute_mw=100.
	if n_elements(water_t) EQ 0 then water_t=1500.
	conc = solute_t*solute_d/(solute_mw*water_t/1000.)

	WIDGET_CONTROL, WID_TEXT_SOLUTE_THICKNESS, set_value =string(solute_t)
	WIDGET_CONTROL, WID_TEXT_SOLUTE_DENSITY, set_value =string(solute_d)
	WIDGET_CONTROL, WID_TEXT_SOLUTE_Mol_Weight, set_value =string(solute_mw)
	WIDGET_CONTROL, WID_TEXT_WATER_THICKNESS, set_value =string(water_t)
	WIDGET_CONTROL, WID_TEXT_CONCENTRATION, set_value =string(conc)

	 Widget_Control, /REALIZE, AX_CONC_CALC_BASE

  XManager, 'AX_CONC_CALC_BASE', AX_CONC_CALC_BASE  ;, /NO_BLOCK

  AX_CONC_CALC_ID = AX_CONC_CALC_BASE
end
