; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;   SAVE_AA.PRO
;
;LAST CHANGED: -----------------------------------  18-Jul-10
;
;PURPOSE:
; This function saves a spectrim generated by XSpecSim as a textfile
;
;CATEGORY:
;	Utility for XSpecSim widget
;
;CALLED FROM XSpecSim
;
; CALLING SEQUENCE:
; Result = sav_AA, en=en, SpecData=SpecData, sequence=sequence, name=name, $ 
;          fltr=fltr, file=file, Modified=Modified, Group = Group
;
; INPUTS:
; This section is for POSITIONAL INPUTS only (not keywords)
; All input parameters are passed as keywords.
;
; KEYWORDS:
; EN        energy values
; SpecData  intensity values
; Sequence  amino acid sequence
; Name      name of peptide or protein
; Fltr      filter for file extension
; File      name of file to write
; Group     name of group leader
; Modified  flag if modified with peptide bond correction
;
;OUTPUTS:
;	A text file with header and projected spectrum of Peptide of interest
;
;COMMON BLOCKS:
;	@XSpecSim_Com		XSpecSim common block
;
;-

function sav_AA, en=en, SpecData=SpecData, sequence=sequence, name=name, $
                  fltr=fltr, file=file, Modified=Modified, Group = Group
@XSpecSim_Com

 if not keyword_set(file) then begin  ;popup file dialog box if name not given
   if not keyword_set(fltr) then fltr='*.txt'
   file=PICKFILE2(/Write, FILTER=fltr, /LPATH, DEFPATH=defpath, TITLE='XSpecSim save ' + name)
 endif

 IF strlen(file) GT 0 THEN BEGIN
 	get_lun,lun
	openw,lun,file
	if keyword_set(name) then begin
		printf, lun, '# Name: ' + name
	endif
	if keyword_set(sequence) then begin
		printf, lun, '#  Sequence: ' + sequence
	endif
	if keyword_set(Modified) then begin
		printf, lun, '# Modified: ' + modified
	endif
	for i =0, n_elements(en)-1 do begin
		;text = FORMAT(en[i])
		printf, lun, en[i], SpecData[i]
	endfor

    close,lun
    free_lun,lun
 ENDIF
    Return, file
end