; Copyright (c) 1998-2017 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_DUV_STACK
;
;LAST CHANGED: ----------------------------------- 	17 Jun 2017
;
; PURPOSE:
;	This procedure reads a stack of Raman or fluorescence spectr
; measured at an array of (x,y) positions into an axis standard stack
;
; CATEGORY:
;	Read=in. Runs stand alone or inside aXis2000.
;
; CALLING SEQUENCE:
; for procedures:
;	READ_DUV_STACK(file=file)
;
; INPUTS:
;	FILE	filename.
;
; KEYWORDS:
;	KEY1:  none
;
; OUTPUTS:
;	*.(dat,ncb) written
;
; COMMON BLOCKS:
; AXUS.COM    standard set of common blocks
; DUV_COM     DUV data specific common block
;
; PROCEDURE:
;	Reads (x,y) positions from position file (NAME_pos.txt
; (convert from Excel to tab delimited text file first)
;   Reads Raman spectra from NAME.txt)
;   sets up (x,y,intensity) stack  (nx, ny, nRaman)

; MODIFICATION HISTORY:
; (17-Jul-17 aph) first version
;-

PRO  READ_DUV_STACM


END

