; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	RD_SPEM.PRO
;
;LAST CHANGED: ----------------------------------- 11-Jan-10
;
;PURPOSE:
;	This reads SPEM data from a XPD labview format data file
;
;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = RD_SPEM(file, NOFILTER=nof, _extra=e )
;
;INPUTS:
;	FILE - SPEM data file
;
;KEYWORD PARAMETERS:
;	NOFILTER - use *.* as filter
;	_EXTRA - pass on other call line parameters
;
; COMMON BLOCKS:
;   @AXIS_COM - set of common blocks for AXIS
;
;MODIFICATION HISTORY:
; (31-Jan-00 aph) add hourglass since slow
;                 THIS is  a file picker warapped around LOADSPEM
; (15-nov-00 cgz) AXIS standard documentation
; (15-nov-00 cgz) migrated LOADSPEM.PRO function into RD_SPEM.PRO
;				  since LOADSPEM is only called from within RD_SPEM.PRO
; (15-nov-00 cgz) Replaced call of DIMEN function by explicit (SIZE(var))(index+1) in LOADSPEM
; (30-nov-00 cgz) Replaced call of nwin with explicit window statement
; (11-Jan-10 aph) commented out all lines calling GLITCH - can not find in package
;                 most likely in one of Eli rotenbergs' combined utility files
; (11-Jan-10 aph) isolated as a separate file from LOADSPEM.PRO
;-

function Rd_SPEM, file, NOFILTER=nof, _extra=e

on_error,2
@axis_com

if n_elements(file) eq 0 then begin  ;popup file dialog box
   fltr='*.*'
   if keyword_set(nof) then fltr='*'
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath)
endif
s = 0
IF strlen(file) GT 0 THEN BEGIN
	pk = 0
	if widget_info(/active) EQ 1 then begin
		pk = get_num(VAL = pk, prompt = 'Peak #', group = axis_id)
		widget_control, /hourglass
	endif else pk = get_num(VAL = pk, prompt = 'Peak #')
	a = loadspem(file,pk=pk)
	; check for NaN values - truncate to exclude these
	test = where(finite(a.y) EQ 1)
	if n_elements(test) LT n_elements(a.y) then begin
		print, 'WARNING: data contains NaN values - removing them'
		ydim = n_elements(test)-2
		d = a.d(*,0:ydim)
		y = a.y(0:ydim)
		a.xl = a.xl +'   Ch# ' + strcompress(string(fix(pk)))
		a={x: a.x, y: y, d: d, xl: a.xl, yl: a.yl, sl: a.sl, dl: a.dl}
		print, 'Image truncated to ', fix(n_elements(a.x)), ' x ', fix(n_elements(a.y))
	endif
	s = {t:'2d', x: a.x, y: a.y, d: 1000.*a.d, xl: a.xl, yl: 'als-SPEM   ' + a.yl, dl: a.sl}
ENDIF

return, s
end

