; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		PRINT_IS_DATABASE
;
;LAST CHANGED: ----------------------------------- 	18 Nov 2016 (aph)
;
; PURPOSE:
;	This  is a wrapper to feed filenames read from a file to AX_ISEELS_DISPLAY
; It reads a text file listing iseels database files one wants to print
; executes AX_ISEELS_DISPLAY for each iseels database file to display it on screen
; One can then use Gadwin PrintScreen, set up on the host computer to print, save to file etc

; CATEGORY:
;	stand alone
;
; CALLING SEQUENCE:
;	PRINT_IS_DATABASE
;
; REQUIRED INPUTS: none.
;
; KEYWORDS: none

; OUTPUT: display on screen
;
; COMMON BLOCKS: none
;;
; SIDE EFFECTS:
;	A window is created/destroyed.
;
; MODIFICATION HISTORY:
; (27-Oct-16 aph) first written
; (18-Nov-16 aph) restructured to get rid of all-files-display-at-start
; -

PRO print_is_database


if not keyword_set(file) then begin
	file = pickfile2(title='Select ISEELS database file LIST', filter='*.txt', /read)
endif

list=strarr(1)
tmp = ' '
i=0
openr, lun, file, /get_lun
t = ax_name(file)
cd, t(0)

while NOT eof(lun) do begin
	readf, lun, tmp
	list(i) = tmp
	i=i+1
	list=[list,' ']
endwhile
close,lun
free_lun,lun

n_files = n_elements(list)
for i = 0, n_files-2 do begin
	tmp = list(i)
	ax_iseels_display, file = tmp
endfor

print, n_files, ' filenames processed from ', file



end