; Copyright (c) 1998-2016 A.P. Hitchcock, B. Watts  All rights reserved
;+
;NAME:
;		NEXUS_COM.PRO
;
;LAST CHANGED: ----------------------------------- 	09 Oct 2016 (aph)
;
; PURPOSE:
;	This file contains the common block for the widget which reads NeXus files
;
; CATEGORY:
;	utility
;
; DEFINITIONS - please update if you extend this common block
;
; nexus					ID of ax_nexus widget
; nexus_head
; NEXUS_ID
; NEXUS_Channel_List	array of detector channel numbers
; NEXUS_Region_List		array of spatial region numbers
; nexus_image			index of the image in a stack
; nexus_ch				number of currently selected detector channel
; nexus_region			number of currently selected spatial region
; nexus_dwell    		dwell time (ms)
; nexus_flip			if set, flip the image
; nexus_path			path to NeXus files
; nexus_lastfile		filename
; draw_nexus			WidgetID of draw widget
; NexusImg				draw window ID value (not same as WidgetID )
; Nexus_no_save			flag - if set, do not auto-save the file read
; AX_NEXUS_VIEWER_ID    location of the base for AX_NEXUS_VIEWER
; anv_folder			last folder where aX-nexus_viewer was applied
; anv_filelist			list of hdf5 files to view
; anv_current_file		index of the currently viewed file
; ANV_NexusImg			identify of Draw widget to display the data
;
; MODIFICATION HISTORY:
; (27-Apr-15 bw ) First version written using sdf_com.pro as a template
; (13-Jul-15 aph) integrated into aXis2000 02-July-15 version
; (04-Apr-16 aph) add ID of the display window
; (08-MAy-16 aph) add parameters needed for AX_NEXUS_VIEWER
;-


COMMON NEXUS_EVENT, nexus, nexus_head, NEXUS_ID, NEXUS_Channel_List, $
      NEXUS_Region_List, nexus_image, nexus_ch, nexus_region,  nexus_dwell, nexus_path, nexus_lastfile, $
      draw_nexus, NexusImg, Nexus_no_save, AX_NEXUS_VIEWER_ID, anv_folder, $
      anv_filelist, anv_current_file, ANV_NexusImg, NEXUS_flip