; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SXM_IPAR.PRO
;
;LAST CHANGED: ----------------------------------- 	22 Jul 2014
;
; PURPOSE:
;	This procedure sets up the data structure sxm_par
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
; for procedures:
;	SXM_IPAR
;
; INPUTS: none
;
; KEYWORDS: none
;
; COMMON BLOCKS:
;	SXM_COMMON
;
; MODIFICATION HISTORY:
; (21-Dec-00 cjj) file obtained from CJJ's source
; (22-Jul-14 aph) AXIS standard header added
;-

PRO Sxm_ipar

@sxm_common

sxm_strlen = 128
IF (n_tags(sxm_par) EQ 0) THEN BEGIN
    sxm_par = $
      { sxm_par, $
        Filever_num: long(0), $	; set in sxm_writefile
        Scan_type: long(0), $
        Dig32_gpib_id: long(-1), $
        Dig80c0_gpib_id: long(-1), $
        Dig80c1_gpib_id: long(-1), $
        Dac_gpib_id: long(-1), $
        Adc_gpib_id: long(-1), $
        mm3000_gpib_id: long(-1), $
        vaxmot_socket: long(-1), $
        Main_data_channel: long(0), $
        Clock_data_channel: long(0), $
        Clock_divideby: long(0), $
        Photodiode_channel: long(0), $
        Xfast: long(0), $       ; what's the fast scan axis?
        Xnotfast_swapped: long(0), $ ; When xfast=0 and xnotfast_swapped=0,
                                   $ ; image_data is (row,column,n_data)
                                   $ ; In all other cases it's
                                   $ ; (column, row, n_data)
                                   $ ; Data should always be swapped before
                                   $ ; saving the file.
        Bidirectional: long(0), $
        Shutopen: long(0), $ ; Does shutter open/close per scanline (=0),
                           $ ; or stay open (=1) ?
        Prescan_pixels: long(0), $
        Mot_baserate: long(0), $ ; final rate is from um/msec
        Mot_accelmsec: long(0), $
        Xy_pix: long(0), $
        Yz_pix: long(0), $
        N_data: long(0), $      ; set in SXM_RCONFIG
        Xy_umstep: float(0), $
        Yz_umstep: float(0), $
        Msec_dwell: float(0), $
        X_center_um: float(0), $
        Y_center_um: float(0), $
        Z_center_um: float(0), $
	Now_nm: float(0), $
        Start_nm: float(0), $
        End_nm: float(0), $
        Xum_per_zum: float(0), $
        Yum_per_zum: float(0), $
        Zp_d_um: float(0), $
        Zp_delta_nm: float(0), $
        Zp_stop_um: float(0), $
        Zp_osa_um: float(0), $
        Undulator_mm: float(0), $
        Ring_gev: float(0), $
        Ring_ma: float(0), $
        Entrance_slit_um: float(0), $
        Exit_slit_um: float(0), $
	Sgm_position: float(0), $
	Sgm_zero_order_steps: float(0), $
	Sgm_steps_per_angstrom: float(0), $
        Disp_min: float(0), $
        Disp_max: float(0), $
        Disp_gamma: float(0), $
        Point_maxnum: long(25), $
	pmt_voltage: float(0), $
	holder_start_temperature: float(0), $
	holder_end_temperature: float(0), $
	ac_start_temperature: float(0), $
	ac_end_temperature: float(0), $
        New_line_available: long(0), $
        Current_line_number: long(0), $
        Scan_command: long(0), $
        Scan_flag: long(0), $
        Scan_complete: long(0), $
        scan_par_shm_id: long(0), $
        image_data_shm_id: long(0), $
        Scaler_divideby: bytarr(8), $ ; Holds the divide-by value for
                                    $ ; each scaler channel
        Scanmode: bytarr(sxm_strlen), $
        Point_nameb: bytarr(sxm_strlen*25), $
	Point_xyb: bytarr(sxm_strlen*25), $
	Beamline: bytarr(sxm_strlen), $
	Sample: bytarr(sxm_strlen), $
	Operator: bytarr(sxm_strlen), $
	Comments1: bytarr(sxm_strlen), $
	Comments2: bytarr(sxm_strlen), $
	Dirname: bytarr(sxm_strlen), $
	Progver_name: bytarr(sxm_strlen), $ ; The program version string
        Systime: bytarr(sxm_strlen), $ ; The date and time of last scan
        Adc_channels_nameb: bytarr(sxm_strlen*8), $
        Other_pixel_channels: bytarr(16), $
        Scanline_channels: bytarr(16), $
	Zp_name: bytarr(sxm_strlen), $
	Disp_mode: bytarr(sxm_strlen), $
        Scaler_channels_nameb: bytarr(sxm_strlen*8), $
	Filename: bytarr(sxm_strlen) }
ENDIF

END



