; Copyright (c) 1998-2012 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		PTYCHO_SELECT.PRO
;
;LAST CHANGED: ----------------------------------- 	08-Dec-12
;
; PURPOSE:
;	This widget allows user to select one of the items in an output file
; from a ptychographic analysis [Shapiro hdf5 files,(Dec-12 ]
;
; CATEGORY:
;	file read-in
;
; CALLING SEQUENCE:
;	Result = PTYCHO_SELECT()
;
; ROUTINES
;
; BUT_PSELECT_DROPLIST.
; WIDGET_KILL_REQUEST.
; BUT_PSELECT_CANCEL.
; BUT_PSELECT_OK.
; PSELECT_BASE_EVENT.
;
; INPUTS: none (transfer vis COMMON
;
; KEYWORDS: none
;
; OUTPUTS: returns selected item
;
; COMMON BLOCKS:
;	ptycho_select_com
;	AXIS_COM	standard set of common blocks
;
; SIDE EFFECTS:
;	A GUI window is created/destroyed.

; MODIFICATION HISTORY:
; (06-Dec-12 aph) first version generated
;-

;-----------------------------------------------------------------
pro  BUT_PSELECT_DROPLIST, Event
@ptycho_select_com
@axis_com
on_error,2

; ---- get new value of ptychography item selected by user
id = widget_info(Event.top, FIND_BY_UNAME = 'PSELECT_DROPLIST')
pt_item_index = WIDGET_INFO(id, /Droplist_select)
pt_item = pt_item_list(pt_item_index)
end

;-----------------------------------------------------------------
pro  WIDGET_KILL_REQUEST, Event
@ptycho_select_com
@axis_com
on_error,2
WIDGET_CONTROL, Event.Top, /DESTROY
pt_item = ''
end


;-----------------------------------------------------------------
pro BUT_PSELECT_CANCEL, Event
@ptycho_select_com
@axis_com
on_error,2
WIDGET_CONTROL, Event.Top, /DESTROY
pt_item = ''
end

;-----------------------------------------------------------------
pro BUT_PSELECT_OK, Event
@ptycho_select_com
@axis_com
on_error,2

; ------ return present value of the drop_down list
id = widget_info(Event.top, FIND_BY_UNAME = 'PSELECT_DROPLIST')
pt_item_index = WIDGET_INFO(id, /Droplist_select)
pt_item = pt_item_list(pt_item_index)
; help, pt_item

WIDGET_CONTROL, Event.Top, /DESTROY
end


; **************************************************************************
; ---------------------------------  PROCESS CLICKS etc -------------------

pro PSELECT_BASE_event, Event
@ptycho_select_com
@axis_com
on_error,2

;  wTarget = (widget_info(Event.id,/NAME) eq 'TREE' ?  $
;      widget_info(Event.id, /tree_root) : event.id)
;  wWidget =  Event.top

;  case wTarget of

  wWidget =  Event.top

  case Event.id of

; --------- kill ptycho_select_widget if use X in upper right corner --------------
    Widget_Info(wWidget, FIND_BY_UNAME='PSELECT_BASE'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_KILL_REQUEST' )then $
       WIDGET_KILL_REQUEST, Event
    end

; ------- cancel operation -----------
    Widget_Info(wWidget, FIND_BY_UNAME='PSELECT_cancel'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_PSELECT_CANCEL, Event
    end

; ------- select item  -----------
    Widget_Info(wWidget, FIND_BY_UNAME='PSELECT_DROPLIST'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_DROPLIST' )then $
        BUT_PSELECT_DROPLIST, Event
    end

; -------- complete operation ---------
    Widget_Info(wWidget, FIND_BY_UNAME='PSELECT_OK'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_PSELECT_OK, Event
    end

    else: print, 'so sorry, but do not understand that button / click'

  endcase

end


pro ptycho_select, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@ptycho_select_com
on_error, 2

;  Resolve_Routine, 'ptycho_select_eventcb',/COMPILE_FULL_FILE  ; Load event callback routines

tx = size(wGroup)
IF tx(1) EQ 0 THEN modal_val=0 else modal_val=1

  PSELECT_BASE = Widget_Base( GROUP_LEADER=wGroup, UNAME='PSELECT_BASE'  $
      , modal = modal_val,SCR_XSIZE=300 ,SCR_YSIZE=100  $	; XOFFSET=5 ,YOFFSET=5
      , /TLB_KILL_REQUEST_EVENTS, TITLE='Select ptchyography item' ,SPACE=3 ,XPAD=3 ,YPAD=3)

  PSELECT_DROPLIST = Widget_Droplist(PSELECT_BASE, UNAME='PSELECT_DROPLIST'  $
      ,XOFFSET=4 ,YOFFSET=4 ,SCR_XSIZE=280 ,SCR_YSIZE=26)

  PSELECT_CANCEL = Widget_Button(PSELECT_BASE, UNAME='PSELECT_cancel'  $
      ,XOFFSET=4 ,YOFFSET=35 ,SCR_XSIZE=60 ,SCR_YSIZE=30  $
      ,/ALIGN_CENTER ,VALUE='Cancel')

  PSELECT_OK = Widget_Button(PSELECT_BASE, UNAME='PSELECT_OK'  $
      ,XOFFSET=168 ,YOFFSET=35 ,SCR_XSIZE=60 ,SCR_YSIZE=30  $
      ,/ALIGN_CENTER ,VALUE='OK')

; ------- populate the pull-down menu
if n_elements(pt_item_list) EQ 0 then begin
	pt_item_list = strarr(6)
	pt_item_list(0) = 'Diffraction_stack'
	pt_item_list(1) = 'Illumination_map'
	pt_item_list(2) = 'Probe_real'
	pt_item_list(3) = 'Probe_imaginary'
	pt_item_list(4) = 'STXM_image'
	pt_item_list(5) = 'Pmask'
endif

widget_control, PSELECT_DROPLIST, set_value = pt_item_list, SET_DROPLIST_SELECT = pt_item_index

  Widget_Control, /REALIZE, PSELECT_BASE

  XManager, 'PSELECT_BASE', PSELECT_BASE, /NO_BLOCK

end

