; Copyright (c) 1998-2013 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		READ_NSRRC_SPEM_GUI
;
;LAST CHANGED: ----------------------------------- 	22-Jul-2013
;
; PURPOSE:
;	This procedure is a widget to select an NSRRC SPEM data file
; It allows user to input relevant parameters. Output is the sample current
; image (returned as aXis2000 2d datafile) and
; the photoelectron 16-channel stack, which is stored on disk
; if extension is '*.ric'- stepper motor scan (r = rough)
; if extension is '*.pic' - piezo scan (p = piezo)
;
; CATEGORY:
;	Data read-in
;
; CALLING SEQUENCE:
;	RESULT = READ_NSRRC_SPEM_GUI()
;
; INPUTS: NONE
;
; KEYWORDS:
;	FILE	initial path & file information
;   SILENT
;
; OUTPUTS:
;	No explicit outputs.   A new window is created if necessary
;
; COMMON BLOCKS:
;	AXIS_COM		 standard set of common blocks
;	NSRRC_SPEM_COM   parameters specific to NSRRC SPEM read-in
;
; MODIFICATION HISTORY:
; (22-Jul-13 aph) first version
;-

;-----------------------------------------------------------------
pro BUT_SPEM_BROWSE, Event, file=file
on_error,2
@axis_com
@nsrrc_spem_com

; ---------------- get new filename ----------
if NOT keyword_set(file) then begin
		fname = pickfile2(Title='Select NSRRC SPEM file (*.ric, *.pic)', $
	                    Filter ='*.ric; *.pic',/LPATH, DEFPATH=defpath)
endif else fname = file
if strlen(fname) GT 0 then begin
	t = ax_name(fname)
	SPEM_path = t(0)
	SPEM_lastfile = t(1)+'.'+t(2)          ; ensure the filename is saved for future use
; update path and file_name in the text box
	id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_filename')
	WIDGET_CONTROL,id, Set_value = SPEM_lastfile
	id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_path')
	WIDGET_CONTROL,id, Set_value = SPEM_path

endif
end

;-----------------------------------------------------------------
pro BUT_SPEM_FILENAME, Event
on_error,2
@axis_com
@nsrrc_spem_com

; update the filename if user changes it manually
	id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_filename')
	WIDGET_CONTROL,id, Get_value = SPEM_lastfile
	id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_path')
	WIDGET_CONTROL,id, Get_value = SPEM_path
	fname = SPEM_path + SPEM_lastfile
;	print, ' SPEM filename set to ' + string(fname)
end

;-----------------------------------------------------------------
pro BUT_SPEM_PATH, Event
on_error,2
@axis_com
@nsrrc_spem_com

; update the filename if user changes it manually
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_filename')
WIDGET_CONTROL,id, Get_value = SPEM_lastfile
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_path')
WIDGET_CONTROL,id, Get_value = SPEM_path
fname = SPEM_path + SPEM_lastfile
;	print, ' Path for SPEM filesset to ' + string(SPEM_path)
end

; ----------------------------------------------------------------
pro CHANGE_ELECTRON_ENERGY, Event
on_error,2
@axis_com
@nsrrc_spem_com
; get the changed value of the energy
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_channel_0')
WIDGET_CONTROL,id, Sensitive=1, Get_value = dummy
SPEM_ch_0 = float(dummy)
;print, 'New Channel 0 electron energy (eV) = ', SPEM_ch_0
WIDGET_CONTROL,id, Sensitive=1, Set_value = string(SPEM_ch_0, format='("   ",f8.2)')
end

; ----------------------------------------------------------------
pro CHANGE_ELECTRON_STEP, Event
on_error,2
@axis_com
@nsrrc_spem_com
; get the changed value of the energy
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_KE_step')
WIDGET_CONTROL,id, Sensitive=1, Get_value = dummy
SPEM_KE_step = float(dummy)
;print, 'New electron energy step (eV) = ', SPEM_KE_step
WIDGET_CONTROL,id, Sensitive=1, Set_value = string(SPEM_KE_step, format='("   ",f6.3)')
end

; ----------------------------------------------------------------
pro CHANGE_BE_KE, Event
on_error,2
@axis_com
@nsrrc_spem_com
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_BUTTON_Binding_E')
if SPEM_BE EQ 1 then SPEM_BE = 0 else  SPEM_BE = 1
WIDGET_CONTROL,id, set_button=SPEM_BE
;if SPEM_BE EQ 1 then  print, 'set binding energy flag to ON' $
;     else print, 'set binding energy flag to OFF'
end

; ----------------------------------------------------------------
pro CHANGE_PHOTON_ENERGY, Event
on_error,2
@axis_com
@nsrrc_spem_com
; get the changed value of the energy
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_photon_E')
WIDGET_CONTROL,id, Sensitive=1, Get_value = dummy
SPEM_photon_energy = float(dummy)
;print, 'New Energy = ', SPEM_photon_energy
WIDGET_CONTROL,id, Sensitive=1, Set_value = string(SPEM_photon_energy, format='("   ",f8.2)')
end

; ----------------------------------------------------------------
pro CHANGE_GRATING, Event
@axis_com
@nsrrc_spem_com
on_error,2

; get the changed grating value
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DROPLIST_grating')
SPEM_grating = WIDGET_INFO(id, /Droplist_select)
; if lox_ch GT lox.Nsignals then lox.channel = 0 else lox.channel = lox_ch(0)
;print, 'Changed grating to ', SPEM_grating_list(SPEM_grating), '  lines/mm'
end


;-----------------------------------------------------------------
pro BUT_SPEM_CANCEL, Event
@axis_com
@nsrrc_spem_com
on_error,2
SPEM_image = 0
WIDGET_CONTROL, Event.Top, /DESTROY
end

;-----------------------------------------------------------------
pro BUT_SPEM_OK,  Event
on_error,2
@axis_com
@nsrrc_spem_com

; get the path & filename
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_filename')
WIDGET_CONTROL,id, Get_value = SPEM_lastfile
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_TEXT_path')
WIDGET_CONTROL,id, Get_value = SPEM_path
fname = SPEM_path + SPEM_lastfile

; ------ read in the data file ----------
SPEM_image = read_nsrrc_spem(file = fname, group = SPEM_ID)
t = ax_name(fname)

axis_log, ' Read SPEM file: ' + t(1) + '.' + t(2)	; need extension to know ric or pic

WIDGET_CONTROL, Event.Top, /DESTROY
return
end


;=============================================

pro WID_BASE_0_event, Event
@axis_com
@nsrrc_spem_com
on_error,2

  wTarget = (widget_info(Event.id,/NAME) eq 'TREE' ?  $
      widget_info(Event.id, /tree_root) : event.id)
  wWidget =  Event.top

  case wTarget of

	Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_filename'): begin
        BUT_SPEM_FILENAME, Event
    end
	Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_path'): begin
        BUT_SPEM_PATH, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_browse'): begin
        BUT_SPEM_BROWSE, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_channel_0'): begin
       CHANGE_ELECTRON_ENERGY, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_KE_step'): begin
       CHANGE_ELECTRON_STEP, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_Binding_E'): begin
       CHANGE_BE_KE, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='WID_TEXT_photon_E'): begin
       CHANGE_PHOTON_ENERGY, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_DROPLIST_grating'): begin
       CHANGE_GRATING, Event
    end

    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_OK'): begin
        BUT_SPEM_OK, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='WID_BUTTON_cancel'): begin
        BUT_SPEM_CANCEL, Event
    end

    else: axis_log, 'Undefined action'
  endcase

end

pro BASE_NSRRC_SPEM,  file=file, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@nsrrc_spem_com
on_error,2

; --------- set MODAL property - if = 1, wait until the READ_NSRRC_SPEM_GUI finishes before continuing
t1=size(wGroup, /type)
IF t1(0) EQ 0 THEN modal_val=0 else modal_val=1

WID_BASE_0 = Widget_Base(GROUP_LEADER=wGroup, UNAME='WID_BASE_0'  $
  ,XOFFSET=5 ,YOFFSET=5 ,SCR_XSIZE=460 ,SCR_YSIZE=337, modal = modal_val  $
  ,TITLE='read NSRRC SPEM data' ,SPACE=3 ,XPAD=3 ,YPAD=3)

; ------- browse for file, or change path or name separately

WID_LABEL_path = Widget_Label(WID_BASE_0, UNAME='WID_LABEL_path'  $
  ,XOFFSET=54 ,YOFFSET=18 ,/ALIGN_LEFT ,VALUE='Path')
WID_TEXT_path = Widget_Text(WID_BASE_0, UNAME='WID_TEXT_path'  $
  ,XOFFSET=92 ,YOFFSET=10 ,SCR_XSIZE=239 ,SCR_YSIZE=24, $
  /FRAME,/EDITABLE ,ALL_EVENTS = 0 , KBRD_FOCUS_EVENTS = 0,$
  XSIZE=20 ,YSIZE=1)

WID_LABEL_filename = Widget_Label(WID_BASE_0,  $
  UNAME='WID_LABEL_filename' ,XOFFSET=41 ,YOFFSET=48  $
  ,SCR_XSIZE=44 ,SCR_YSIZE=18 ,/ALIGN_LEFT ,VALUE='Filename')
WID_TEXT_filename = Widget_Text(WID_BASE_0,  $
  UNAME='WID_TEXT_filename' ,XOFFSET=94 ,YOFFSET=48,  $
  /FRAME, /EDITABLE, ALL_EVENTS = 0 , KBRD_FOCUS_EVENTS = 0, $
  SCR_XSIZE=237 ,SCR_YSIZE=24, XSIZE=20 ,YSIZE=1)

WID_BUTTON_browse = Widget_Button(WID_BASE_0,  $
  UNAME='WID_BUTTON_browse' ,XOFFSET=360 ,YOFFSET=30  $
  ,SCR_XSIZE=72 ,SCR_YSIZE=36 ,/ALIGN_CENTER ,VALUE='Browse')

; ---------- set energy analyzer parameters ---------
WID_LABEL_ELECTRONS = Widget_Label(WID_BASE_0, UNAME='WID_LABEL_ELECTRONS'  $
  ,XOFFSET=81 ,YOFFSET=120 ,/ALIGN_LEFT ,VALUE='ELECTRONS')


WID_LABEL_E_chan_0 = Widget_Label(WID_BASE_0,  $
  UNAME='WID_LABEL_E_chan_0' ,XOFFSET=49 ,YOFFSET=157  $
  ,SCR_XSIZE=113 ,SCR_YSIZE=18 ,/ALIGN_LEFT ,VALUE='Channel 0 energy (eV)')
WID_TEXT_channel_0 = Widget_Text(WID_BASE_0,  $
  UNAME='WID_TEXT_channel_0' ,XOFFSET=176 ,YOFFSET=156  $
  ,SCR_XSIZE=97 ,SCR_YSIZE=24 ,/EDITABLE ,XSIZE=20 ,YSIZE=1)


WID_LABEL_E_step = Widget_Label(WID_BASE_0,  $
  UNAME='WID_LABEL_E_step' ,XOFFSET=48 ,YOFFSET=194  $
  ,SCR_XSIZE=113 ,SCR_YSIZE=18 ,/ALIGN_LEFT ,VALUE='Energy step (eV)')
WID_TEXT_KE_step = Widget_Text(WID_BASE_0, UNAME='WID_TEXT_KE_step'  $
  ,XOFFSET=175 ,YOFFSET=193 ,SCR_XSIZE=97 ,SCR_YSIZE=24  $
  ,/EDITABLE ,XSIZE=20 ,YSIZE=1)

; ---------- select binding energy or kinetic energy -------
WID_BASE_1 = Widget_Base(WID_BASE_0, UNAME='WID_BASE_1' ,XOFFSET=48  $
  ,YOFFSET=235 ,TITLE='IDL' ,COLUMN=1 ,/NONEXCLUSIVE)
WID_BUTTON_Binding_E = Widget_Button(WID_BASE_1,  $
  UNAME='WID_BUTTON_Binding_E' ,/ALIGN_LEFT, VALUE='Binding energy')


; ------ beamline parameters
WID_LABEL_photons = Widget_Label(WID_BASE_0,  $
  UNAME='WID_LABEL_photons' ,XOFFSET=362 ,YOFFSET=120  $
  ,/ALIGN_LEFT ,VALUE='PHOTONS')

WID_LABEL_photon_energy = Widget_Label(WID_BASE_0, UNAME='WID_LABEL_photon_energy'  $
  ,XOFFSET=334 ,YOFFSET=153 ,SCR_XSIZE=113 ,SCR_YSIZE=18  $
  ,/ALIGN_LEFT ,VALUE='Photon energy (eV)')
WID_TEXT_photon_E = Widget_Text(WID_BASE_0,  $
  UNAME='WID_TEXT_photon_E' ,XOFFSET=338 ,YOFFSET=174  $
  ,SCR_XSIZE=97 ,SCR_YSIZE=24 ,/EDITABLE ,XSIZE=20 ,YSIZE=1)

SPEM_grating_list = [ '275', '400', '800', '1200' ]
WID_DROPLIST_grating = Widget_DropList(WID_BASE_0, UNAME='WID_DROPLIST_grating'  $
  , /DYNAMIC_RESIZE, KBRD_FOCUS_EVENTS = 0, SENSITIVE=1, TITLE='Grating   ' $
  , XOFFSET=328 ,YOFFSET=210,SCR_XSIZE=110 ,SCR_YSIZE=20  $
  , VALUE=SPEM_grating_list ,XSIZE=18 ,YSIZE=1)

; ---------- execute the read-in --------
WID_BUTTON_OK = Widget_Button(WID_BASE_0, UNAME='WID_BUTTON_OK'  $
  ,XOFFSET=360 ,YOFFSET=262 ,SCR_XSIZE=76 ,SCR_YSIZE=36  $
  ,/ALIGN_CENTER ,VALUE='OK')

WID_BUTTON_cancel = Widget_Button(WID_BASE_0,  $
  UNAME='WID_BUTTON_cancel' ,XOFFSET=232 ,YOFFSET=262  $
  ,SCR_XSIZE=93 ,SCR_YSIZE=36 ,/ALIGN_CENTER ,VALUE='Cancel')

; -------- load previous values if they exist ---------
; ----------- load last path & file information --------
if size(SPEM_path,/type) NE 0 then widget_control, WID_TEXT_path, set_value = SPEM_path
if size(SPEM_lastfile,/type) NE 0 then  widget_control, WID_TEXT_filename, set_value = SPEM_lastfile

; ------- load electron analyser parameters
if size(SPEM_ch_0,/type) NE 0 then widget_control, WID_TEXT_channel_0 $
			, Set_value = string(SPEM_ch_0, format='("   ",f8.2)')
if size(SPEM_KE_step,/type) NE 0 then widget_control, WID_TEXT_KE_step $
			,set_value = string(SPEM_KE_step, format='("   ",f6.3)')

; ----------- set current value of BE flag
if size(SPEM_BE,/type) NE 0 then begin
  if SPEM_BE EQ 1 then widget_control, WID_BUTTON_Binding_E, set_button = 1 $
     else widget_control, WID_BUTTON_Binding_E, set_button = 0
endif
; -------- load beamline parameters
if size(SPEM_photon_energy,/type) NE 0 then widget_control, WID_TEXT_photon_E, $
	set_value = string(SPEM_photon_energy, format='("   ",f8.2)')
if size(SPEM_grating,/type) NE 0 then widget_control, WID_DROPLIST_grating, $
	SET_DROPLIST_SELECT = SPEM_grating

; --------- start the widget gui ------------
Widget_Control, /REALIZE, WID_BASE_0

XManager, 'WID_BASE_0', WID_BASE_0    ;, /NO_BLOCK
SPEM_ID = WID_BASE_0

end
;
; ------- start the GUI ---------------
;
FUNCTION READ_NSRRC_SPEM_GUI, FILE=FILE, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@nsrrc_spem_com
on_error,2

; ------ set initial state of BE flag unless set already
if size(SPEM_BE,/type) EQ 0 then SPEM_BE = 0

SPEM_image = 0
if keyword_set(file) then begin
	BASE_NSRRC_SPEM, GROUP_LEADER=wGroup, file=file, _EXTRA=_VWBExtra_
endif else begin
	BASE_NSRRC_SPEM, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
endelse

return, SPEM_image

end
