; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_NEXUS_VIEWER
;
;LAST CHANGED: ----------------------------------- 10-may-16
;
;PURPOSE:
;	This set of procedures is a widget to view all Nexus format (hdf5) files in a folder
; with option to delete (put in discard sub-folder)
;
;CATEGORY:
;	AXIS: utility, runs independent of aXis2000
;
; AX_NEXUS_VIEWER_EVENT ROUTINES:
; TEXT_SDF_FNAME		modify filename; when changed, execute BUT_SDF_FNAME_BROWSE to get parameters
; BUT_SDF_FNAME_BROWSE 	browse for new filename; if found, load new parameters
; ANV_BUT_DISMISS		dismiss the widget

;
;COMMON BLOCKS:
; @AXIS_COM     standard set of common for aXis2000
;	@NEXUS_COM		standard set of common for NEXUS
;
;MODIFICATION HISTORY:
; (08-May-16 aph) first version
; (10-MAy-16 aph)  add overwrite to file_move
;-

;-----------------------------------------------------------------

pro ANV_SLIDER_select, Event
@axis_com
@nexus_com
on_error,2
	id = widget_info(Event.top, FIND_BY_UNAME = 'ANV_SLIDER_select')
	WIDGET_CONTROL,id, get_value = text
	anv_current_file = fix(text)
	if anv_current_file GE n_elements(anv_filelist) then $
		anv_current_file =  n_elements(anv_filelist)-1
	print, 'Current file # ', anv_current_file, '    ', anv_filelist(anv_current_file)
	t = ax_name(anv_filelist(anv_current_file))
	id = widget_info(Event.top, FIND_BY_UNAME = 'ANV_TEXT_filename')
	WIDGET_CONTROL,id, Set_VALUE = t(1)
	ANV_UPDATE
end


pro ANV_UPDATE
@axis_com
@nexus_com
on_error,2

	widget_control, /hourglass
	anv_file = anv_Filelist(anv_current_file)
	print, 'Reading file: ', anv_file
	nexus_head = read_nexus(anv_file, /header_only)
	tmp = read_nexus(anv_file, channel= 0, region = 0, xy_correct=xy_correct_flag, one_image =0, /no_save)
; ----- update filename
	t = ax_name(anv_filelist(anv_current_file))
	id = widget_info(AX_NEXUS_VIEWER_ID, FIND_BY_UNAME = 'ANV_TEXT_filename')
	WIDGET_CONTROL,id, Set_VALUE = t(1)
	if nexus_head.Type EQ 'sample image' then begin
		; ------ indicate E if possible
		id = widget_info(AX_NEXUS_VIEWER_ID, FIND_BY_UNAME = 'ANV_TEXT_energy')
		WIDGET_CONTROL,id, set_value = string(tmp.e)
		; ----- indicate dwell (ms)
		id = widget_info(AX_NEXUS_VIEWER_ID, FIND_BY_UNAME = 'ANV_TEXT_dwell')
		WIDGET_CONTROL,id, set_value = string(nexus_dwell, format='(F7.2)')
	endif
;	------ plot the data
	wset, ANV_NexusImg
	tmp.dl = ''
	make_square,tmp
	if tmp.t EQ '2d' then splot2d, tmp
	if tmp.t EQ '1d' then plot, tmp.x, tmp.d
end

;-----------------------------------------------------------------

pro ANV_BUT_DISCARD, Event
@axis_com
@nexus_com
on_error,2

	anv_file = anv_filelist(anv_current_file)
	t = ax_name(anv_file)

; ----- move the file
	file_move, anv_file, anv_folder + 'discard', /overwrite
; ---- modify anv_filelist to remove that name
	anv_nfiles = n_elements(anv_filelist)
;	print, '# of files in list before discard = ', 	anv_nfiles
	for i = anv_current_file, anv_nfiles-2 do  anv_filelist(i) = anv_filelist(i+1)
	anv_nfiles = anv_nfiles - 1
	anv_filelist = anv_filelist[0:anv_nfiles-1]
;	print, '# of files in list after discard = ', 	anv_nfiles
; ---- change the maximum of the slider
	id = widget_info(AX_NEXUS_VIEWER_ID, FIND_BY_UNAME = 'ANV_SLIDER_select')
	WIDGET_CONTROL,id, set_slider_max = anv_nfiles
	ANV_UPDATE
	print, t(1), '  moved to the discard folder'

end


;-----------------------------------------------------------------

pro ANV_BUT_DISMISS, Event
@axis_com
@nexus_com
on_error,2

WIDGET_CONTROL, Event.Top, /DESTROY
end


pro AX_NEXUS_VIEWER_event, Event
@axis_com
@nexus_com
on_error,2

  case Event.id of

    Widget_Info(Event.top, FIND_BY_UNAME='ANV_SLIDER_select'): begin
        ANV_SLIDER_select, Event
    end
	Widget_Info(Event.top, FIND_BY_UNAME='ANV_BUT_DISMISS'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ANV_BUT_DISMISS, Event
    end
    Widget_Info(Event.top, FIND_BY_UNAME='ANV_BUT_DISCARD'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ANV_BUT_DISCARD, Event
    end
	Widget_Info(Event.top, FIND_BY_UNAME='ANV_TEXT_energy'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ANV_TEXT_energy, Event
    end
    else: print, 'AX_NEXUS_VIEWER - unknown button clicked'
  endcase

end

pro BASE_AX_NEXUS_VIEWER, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@nexus_com
on_error,2

; ------- ask user to identify folder and generate list of all *.hdf5 files
if n_elements(anv_folder) GT 0 then begin
	; should really check if anv_folder exists
	anv_filelist = dialog_pickfile(get_path=folder, title='Nexus file viewer: select files to process', $
	     /multiple_files, filter = '*.hdf5', path = anv_folder)
endif else  begin
	anv_filelist = dialog_pickfile(get_path=folder, title='Nexus file viewer: select files to process', $
	    /multiple_files, filter = '*.hdf5')
endelse

; help, anv_filelist
print, 'AX_NEXUS_VIEWER processing folder = ', folder
anv_folder = folder		; save for future access
anv_current_file = 0
anv_n_files = n_elements(anv_filelist)

; ------- kluge for windows list of files - last 1 is the first file !
if !version.os_family EQ 'Windows' then begin
    t=anv_filelist(0)
    for i = 0, anv_n_files-2 do  anv_filelist(i) = anv_filelist(i+1)
    anv_filelist(anv_n_files-1) = t
endif

 BASE_ANV = Widget_Base( GROUP_LEADER=wGroup, UNAME='BASE_ANV '  $
      ,XOFFSET=5 ,YOFFSET=5 $
      ,TITLE='NEXUS file viewer' ,SPACE=3 ,XPAD=3 ,YPAD=3, column = 2)

  ANV_DRAW = Widget_Draw(BASE_ANV, UNAME='ANV_DRAW' ,XOFFSET=28  $
      ,YOFFSET=15 ,SCR_XSIZE=360 ,SCR_YSIZE=340)

col1 = widget_base(BASE_ANV,XOFFSET=400)

; --- use common length for folder and filenames
  anv_text_length = 50
  ANV_LABEL_folder = Widget_Label(col1, UNAME='ANV_LABEL_folder'  $
      , YOFFSET=1, /ALIGN_LEFT ,VALUE='Folder')
  ANV_TEXT_folder = Widget_Text(col1, UNAME='ANV_TEXT_folder'  $
      , YOFFSET=20,XSIZE=anv_text_length, YSIZE=1)

  ANV_LABEL_filename = Widget_Label(col1,  $
      UNAME='WID_LABEL_filename' ,YOFFSET=51  $
      , /ALIGN_LEFT ,VALUE='Filename')
  ANV_TEXT_filename = Widget_Text(col1,  $
      UNAME='ANV_TEXT_filename' ,YOFFSET=74  $
      , XSIZE=anv_text_length ,YSIZE=1)

   ANV_LABEL_Energy = Widget_Label(col1,  $
      UNAME='ANV_LABEL_Energy' , YOFFSET=112  $
      ,/ALIGN_LEFT ,VALUE='Energy')
   ANV_TEXT_energy = Widget_Text(col1, UNAME='ANV_TEXT_energy'  $
      ,XOFFSET = 75, YOFFSET=112, XSIZE=10, YSIZE=1)

    ANV_LABEL_Dwell = Widget_Label(col1,  $
      UNAME='ANV_LABEL_Dwell' , YOFFSET=143  $
      ,/ALIGN_LEFT ,VALUE='Dwell time (ms)')
    ANV_TEXT_dwell = Widget_Text(col1, UNAME='ANV_TEXT_dwell'  $
      , XOFFSET = 75, YOFFSET=163, XSIZE=10, YSIZE=1)

  ANV_SLIDER_select = Widget_Slider(col1,  $
      UNAME='ANV_SLIDER_select' ,YOFFSET=240  $
      , maximum = anv_n_files, scroll = 1 $
      ,SCR_XSIZE=182)

  ANV_BUT_DISCARD = Widget_Button(col1,  SCR_YSIZE = 24, SCR_XSIZE=70, $
      UNAME='ANV_BUT_DISCARD' ,XOFFSET=200 ,YOFFSET=250  $
      ,/ALIGN_CENTER ,VALUE='Discard')

  ANV_BUT_DISMISS = Widget_Button(col1, UNAME='ANV_BUT_DISMISS'  $
      ,XOFFSET=200 ,YOFFSET=290, SCR_YSIZE = 36, SCR_XSIZE=70   $
      ,/ALIGN_CENTER ,VALUE='Dismiss')

; Load data into widget
WIDGET_CONTROL,ANV_TEXT_folder, Set_VALUE = folder
t = ax_name(anv_filelist(anv_current_file))
WIDGET_CONTROL,ANV_TEXT_filename, Set_VALUE = t(1)

; ------ OK all set, lets generate the widget

  Widget_Control, /REALIZE, BASE_ANV

  XManager, 'AX_NEXUS_VIEWER', BASE_ANV, /NO_BLOCK

 AX_NEXUS_VIEWER_ID = BASE_ANV

; ----------- get info needed to access the draw_window (only after REALIZE !)
widget_control, ANV_DRAW, GET_value=ANV_NexusImg

; ----- load first file
 ANV_UPDATE   ;, BASE_ANV

end




pro ax_nexus_viewer, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com
@nexus_com
on_error,2

  BASE_AX_NEXUS_VIEWER, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_

; empty stub to load
end
