; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  STACK_MESH
;
;LAST CHANGED: ----------------------------------- 31-Jan-11
;
; PURPOSE:
;	This procedure changes mesh of a stack
;
; CATEGORY:
;	stack processing; stand alone operation or from axis2000
;
; CALLING SEQUENCE:
;	STACK_MESH
;
; INPUTS: none
;
; KEYWORDS: none
;
; OUTPUTS: 	none
;
; COMMON BLOCKS:
; AXIS_COM	standard set of common blocks
; stack_process_com
; BSIF_com
; volume_data, image_stack
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (31-jan-11 aph) first version generated from stack_append
;-

PRO stack_mesh
@axis_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com

on_error,2

fltr = '*.ncb'

file1 = pickfile2(/READ, TITLE = 'stack to re-mesh or re-size', FILTER=fltr, /LPATH, DEFPATH=defpath)
if strlen(file1) LE 0 THEN return  ; bail-out if no filename
t = ax_name(file1)
fileshort = t(1)
stack_rb, file1
stack1 = image_stack
n_energies = n_elements(eV)

; --- compute and display average image of stack
tmp = fltarr(n_cols, n_rows)
for i = 0, n_elements(eV)-1 do tmp = tmp +image_stack(*,*,i)
x = findgen(n_cols)  & y = findgen(n_rows)
xstep = (x_stop - x_start)/n_cols
ystep = (y_stop - y_start)/n_rows
x = x_start + xstep*x
y = y_start + ystep*y
dl = 'avg stack ' + fileshort
tmp = {t:'2d', x:x, y:y, d:tmp, e: 1., xl: 'x', yl: 'y', dl: dl}

; --- if aXis2000 running, use buffer 0 to display average
CurBuf = 0
HANDLE_VALUE, Data(CurBuf), tmp, /set
Label(CurBuf) = tmp.dl
PlotBuf,CurBuf

; ------ alternatively, if run outside of axis, pop up a graphic window
; ------ NOT YET WRITTEN

;test = get_text(Prompt = 'Change <M>esh (keep same image size) or change <I>mage size (keep same pixel size) ?',$
;         val = 'M', group=axis_ID)
test = 'I'
text = strarr(2)
text(0) = 'change MESH (and keep same image size) (Yes) OR '
text(1) = 'Change IMAGE SIZE (and keep same pixel size) (No)'
t = dialog_message(text, $
         /question, /cancel, dialog_parent=axis_ID)
if t EQ 'Cancel' then return
if t EQ 'Yes' then test = 'M'

if test EQ 'M' then begin
; ---------- change mesh but keep image size the same
	tmp1 = ax_interp(tmp)
	mesh = fltarr(2)
	mesh(0) = n_elements(tmp1.x)
	mesh(1) = n_elements(tmp1.y)
	image_stack2 = fltarr(mesh(0), mesh(1), n_elements(eV))
	for i = 0, n_elements(eV) -1 do begin
		tmp.d = image_stack(*,*,i)
		tmp1 = ax_interp(tmp, mesh = mesh)
		image_stack2(*,*,i) =  tmp1.d
	endfor
	n_cols = mesh(0)
	n_rows = mesh(1)

endif else begin

; ---------  keep pixel size and expand or contract size of the image
	xmin = x_start & xmax = x_stop
	ymin = y_start & ymax = y_stop

	xmin = get_num(Prompt = 'x_min ', val = xmin, group=axis_ID)
	xmax = get_num(Prompt = 'x_max ', val = xmax, group=axis_ID)
	ymin = get_num(Prompt = 'y_min ', val = ymin, group=axis_ID)
	ymax = get_num(Prompt = 'y_max ', val = ymax, group=axis_ID)
	nxn = (xmax - xmin)/xstep + 1
	nyn = (ymax - ymin)/ystep + 1
	image_stack2 = fltarr(nxn, nyn, n_elements(eV))
; ------- debug values
	print, 'xmin, xmax, ymin, ymax'
	print, xmin, xmax, ymin, ymax
	print, 'x_start, X_stop, xstep'
	print, x_start, X_stop, xstep
	print, 'y_start, y_stop, ystep'
	print, y_start, y_stop, ystep

	; ------- identify indices in the new and old stacks
	nxmin = 0  & nymin = 0
	nxmax = n_cols
	nymax = n_rows
	nxmin2 = nxmin
	nymin2 = nymin
	nxmax2 = nxmax
	nymax2 = nymax
	del_x = xstep/2.
	del_y = ystep/2.
	if xmin LE x_start then nxmin2 = (x_start - xmin)/xstep
	if xmin GT x_start then nxmin  = (xmin - x_start)/xstep

	if xmax GE x_stop-del_x then nxmax2 = fix(nxmax-nxmin) + nxmin2
	if xmax LT x_stop-del_x then begin
		nxmax = nxmax - (x_stop - xmax)/xstep
		nxmax2 = nxmin2 + fix(nxmax-nxmin+1)
	endif

	if ymin LE y_start then nymin2 = (y_start - ymin)/ystep
	if ymin GT y_start then nymin  = (ymin - y_start)/ystep

	if ymax GE y_stop-del_y then nymax2 = n_rows + nymin2
	if ymax LT y_stop-del_y then begin
		nymax = nymax - (y_stop - ymax)/ystep
		nymax2 = nymin2 + fix(nymax-nymin+1)
	endif

	nxmin=fix(nxmin) & nxmax = fix(nxmax)
	nymin=fix(nymin) & nymax = fix(nymax)
	nxmin2=fix(nxmin2) & nxmax2 = fix(nxmax2)
	nymin2=fix(nymin2) & nymax2 = fix(nymax2)
; - kluge to correct for rounding errors
	if (nxmax2 - nxmin2) GT (nxmax - nxmin) then nxmax2 = nxmin2 + fix(nxmax-nxmin)
	if (nymax2 - nymin2) GT (nymax - nymin) then nymax2 = nymin2 + fix(nymax-nymin)
	print, 'OLD stack size'
	help, image_stack
	print, 'nxmin, nxmax, nymin, nymax'
	print, nxmin, nxmax, nymin, nymax
	print, 'New stack size'
	help, image_stack2
	print, 'nxmin2, nxmax2, nymin2, nymax2'
	print, nxmin2, nxmax2, nymin2, nymax2

	for i = 0, n_elements(eV)-1 do begin
		fill = mean(image_stack(*,*,i))
		image_stack2(*,*,i) = fill
		image_stack2(nxmin2:nxmax2-1, nymin2:nymax2-1,i) = image_stack(nxmin:nxmax-1, nymin:nymax-1,i)
;		if nxn GE n_cols and nyn GE n_rows then $
;			image_stack2(nxmin:nxmax-1,nymin:nymax-1,i) = image_stack(*,*,i)
;		if nxn LT n_cols and nyn GE n_rows then	$
;			image_stack2(*,nymin:nymax-1,i) = image_stack(nxmin:nxmax-1,*,i)
;		if nxn GE n_cols and nyn LT n_rows then $
;			image_stack2(nxmin:nxmax-1,*,i) = image_stack(*,nymin:nymax-1,i)
;		if nxn LT n_cols and nyn LT n_rows then	$
;			image_stack2(nxmin:nxmin+nxmax-1,nymin:nymin+nymax-1,i) = $
;			             image_stack(nxmin:nxmax-1,nymin:nymax-1,i)
	endfor
	n_cols = nxn
	n_rows = nyn
endelse

; ------- change bsif_com parameters
x = findgen(n_cols)  & y = findgen(n_rows)
xstep = (x_stop - x_start)/n_cols
x = x_start + xstep*x
ystep = (y_stop - y_start)/n_rows
y = y_start + ystep*y
image_stack = image_stack2
print, 'after re-mesh'
help, image_stack

; ----- write out re-meshed stack -----------------
file = pickfile2(/READ, TITLE = 'Re-meshed stack filename', FILTER=fltr, /LPATH, DEFPATH=defpath)
if strlen(file) NE 0 then begin
	t = ax_name(file)
	filename = string(t(0)) + string(t(1)) + '.ncb'
	stack_wb, filename
endif
ax_wait,/off		; turn off hourglass (sometimes sticks on)
return

end

