; Copyright (c) 2005 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	SET_DIGITS
;
;LAST CHANGED: ----------------------------------- 23-Jun-05
;
;PURPOSE:
;	This function returns a string corresponding to the value with the number of digits set by the user
;
;CATEGORY:
;	STAND ALONE: string manipulation
;
;CALLING SEQUENCE:
;	RESULT = SET_DIGITS(VALUE, PLACES)

;INPUTS:
;	VALUE	value to convert
;   PLACES	number of significant figures
;
;KEYWORDS: none
;
;OUTPUTS: 	retunrs text string with PLACES
;
;COMMON BLOCKS:
;
;
;MODIFICATION HISTORY:
; (23-Jun-05 aph) first version


FUNCTION set_digits, value, places


ts = fix(alog10(value))
; if ts eq 0 AND value LT 10 then ts = ts + 1
tx = places-ts
;print, 'power ', tx
if ts GT 0 then tx = tx - 1
t = fix(value*(10.^tx))
;print, t
s = float(fix(value*(10.^tx))/10.^tx)
;print, string(s)

;print, value, places, s, format='(G13.6," truncated to ",i1," digits is ", a)'

RETURN, string(s)
END