; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	DINDEX 
; 
;LAST CHANGED: ----------------------------------- 25-feb-00 
; 
;PURPOSE: 
;	This function gets the index of the data point in a 2-d data structure (image) 
; which is closest to the cursor (x,y) values 
; It assumes the 2-d data structure has (x,y,d) components 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	Result = DIndex(X,Y,tmp) 
; 
;CALLED FROM AXIS: 
;  many paces 
; 
;INPUTS: 
;	X - X cursor position in data units 
;   Y - Y cursor position in data units 
;   TMP  - the 1-d data structure 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	IND - (i,j) index of data closest to cursor position 
; 
;COMMON BLOCKS: none 
; 
;MODIFICATION HISTORY: 
; (27-may-97 aph)  first written, in AXIS 
; (03-Mar-98 aph) segregated as separate file 
; (13-Apr-98 aph) treat (x,y) independently 
; (25-feb-00 aph) AXIS standard documentation 
;- 
 
Function DIndex,X,Y,tmp 
 
on_error,2 
 
Ind = intarr(2) 
Ind(0) = 0  & Ind(1) = 0 
lindX=where(tmp.x LE X,lcountx) 
if lcountx NE 0 THEN BEGIN 
	dindX=size(lindX)    ; only identify data if it is inside frame 
	Ind(0) = dindX(1)-1 
endif 
lindY=where(tmp.y LE Y,lcounty) 
if lcounty NE 0 THEN BEGIN 
	dindY=size(lindY) 
	Ind(1) = dindY(1)-1 
endif 
return, Ind 
end