function load_spm, file, NOFILTER=nof, _extra=e 
 
; ------------------- last changed 30-sep-00 
; adapted to put a file picker around LOADSPEM 
; (31-jan-00 aph) add hourglass 
; (30-sep-00 aph) define filter 
 
on_error,2 
@axis_com
 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   fltr='*.spc' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
s = 0 
IF strlen(file) GT 0 THEN BEGIN 
	WIDGET_CONTROL, Bad_ID = BadID, /hourglass 
	a = gen_read(file) 
	t = size(a.x)  & n_spectra = t(1) 
	dl = a.fname 
	xl = 'Binding Energy (eV)' 
	yl = 'ALS SPEM XPS' 
	if t(0) EQ 1 then begin 
		x = reverse(-1.*a.x) 
		d = reverse(reform(a.y)) 
		s = {t:'1d', x: x, d: d, xl: xl, dn: d,  dl: dl} 
	endif else begin 
		pmt =  'Ch# ('+strcompress(string(fix(n_spectra)))+')' 
		if widget_info(/active) EQ 1 then begin 
			nc = get_num(VAL = 1, prompt = pmt, group = axis_id) 
		endif else 	nc = get_num(VAL = 1, prompt = pmt) 
		nc = nc - 1 
		x = -1.*a.x(nc,*) & x = reverse(reform(x)) 
		d = a.y(nc,*) & d = reverse(reform(d)) 
		s = {t:'1d', x: x, d: d, xl: xl, dn: d,  dl: dl} 
	endelse 
ENDIF 
 
return, s 
end 
 
