; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AXIS_APP 
; 
;LAST CHANGED: ----------------------------------- 23-feb-00 
; 
;PURPOSE: 
;	This procedure appends two 1-d AXIS data structures (spectra). 
; If the data overlaps the user is prompted to select inclusion 
; of the first, second or average data in the overlapping region. 
; 
;CATEGORY: 
;	AXIS: spectra analysis 
; 
;CALLING SEQUENCE: 
;	AXIS_APP 
; 
;CALLED FROM AXIS: 
;	Spectra->Add->Append 
; 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: 
;	The appended spectrum is placed in buffer 0. 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; (09-aug-97 aph) isolated from AXIS 
; (24-jan-98 aph) corrrected to add s.dn 
; (14-jun-98 aph) axis_com 
; (02-jan-00 aph) 1st, 2nd, average in common region; AXIS standard documentation 
; (23-feb-00 aph) add groupID to call to Buffer 
;- 
 
PRO axis_app 
@axis_com
on_error,2 
 
HANDLE_VALUE, Data(Curbuf), tmp1 
IF n_tags(tmp1) EQ 0 THEN RETURN 
If tmp1.t EQ '1d' then begin 
	WIDGET_CONTROL, Uprompt, SET_VALUE='Append two buffers' 
	b = Buffer(group = AXIS_ID) 
	HANDLE_VALUE, Data(b(0)), tmp2 
	IF (n_tags(tmp2) EQ 0) THEN RETURN 
	IF tmp2.t EQ '1d' then begin 
		xord = sort(tmp1.x) &  tmp1.x = tmp1.x(xord) & tmp1.d = tmp1.d(xord) 
		xord = sort(tmp2.x) &  tmp2.x = tmp2.x(xord) & tmp2.d = tmp2.d(xord) 
		np1 = n_elements(tmp1.x) 
		np2 = n_elements(tmp2.x) 
		np = np1 + np2 
		tmp = {t:'1d',d: FLTARR(np), x: FLTARR(np), xl: '',dn:FLTARR(np), dl: ''} 
		overlap = 0 
		if tmp1.x(np1-1) LT tmp2.x(0) then begin 
			tmp.x = [tmp1.x, tmp2.x] 
			tmp.d = [tmp1.d, tmp2.d] 
			overlap = 1 
		endif 
		if tmp2.x(np2-1) LT tmp1.x(0) then begin 
			tmp.x = [tmp2.x, tmp1.x] 
			tmp.d = [tmp2.d, tmp1.d] 
			overlap = 1 
		endif 
		if overlap NE 1 then begin 
; data overlaps - ask user what to do 
		   	which = get_num(prompt = 'Common data points. Use (1)st, (2)nd, (3)Avg ?', val = 3, group = Axis_ID) 
			which = strcompress(string(fix(which))) 
			CASE which OF 
			   ' 1': BEGIN 
			   		xnewL = where(tmp2.x LT tmp1.x(0), countL) 
			   		xnewH = where(tmp2.x GT tmp1.x(np1-1), countH) 
					xnew = 0 
			   		if countL GT 0 then xnew = [xnew,xnewL] 
			   		if countH GT 0 then xnew = [xnew,xnewH] 
			   		if n_elements(xnew) GT 1 then begin 
			   			xnew = xnew(1:n_elements(xnew)-1) 
				   		x = [tmp1.x, tmp2.x(xnew)] 
				   		d = [tmp1.d, tmp2.d(xnew)] 
				   		xord = sort(x) 
				   		x = x(xord) 
				   		d = d(xord) 
			   		endif else begin 
			   			x = tmp1.x 
			   			d = tmp1.d 
			   		endelse 
			   		tmp = {t:'1d',d: d, x: x, xl: tmp1.xl, dn:d, dl: ''} 
				END 
				' 2': BEGIN 
			   		xnewL = where(tmp1.x LT tmp2.x(0), countL) 
			   		xnewH = where(tmp1.x GT tmp2.x(np2-1), countH) 
					xnew = 0 
			   		if countL GT 0 then xnew = [xnew,xnewL] 
			   		if countH GT 0 then xnew = [xnew,xnewH] 
			   		if n_elements(xnew) GT 1 then begin 
			   			xnew = xnew(1:n_elements(xnew)-1) 
				   		x = [tmp2.x, tmp1.x(xnew)] 
				   		d = [tmp2.d, tmp1.d(xnew)] 
				   		xord = sort(x) 
				   		x = x(xord) 
				   		d = d(xord) 
			   		endif else begin 
			   			x = tmp2.x 
			   			d = tmp2.d 
			   		endelse 
			   		tmp = {t:'1d',d: d, x: x, xl: tmp1.xl, dn:d, dl: ''} 
				END 
				' 3': BEGIN 
;	generate averaged common region 
			   		xnew = where(tmp1.x GT tmp2.x(0) AND tmp1.x LT tmp2.x(np2-1), count) 
					t1 = {t:'1d',d: tmp1.d(xnew), x: tmp1.x(xnew), xl: tmp1.xl, dl: ''} 
			   		xnew = where(tmp2.x GT tmp1.x(0) AND tmp2.x LT tmp1.x(np1-1), count) 
					t2 = {t:'1d',d: tmp2.d(xnew), x: tmp2.x(xnew), xl: tmp1.xl, dl: ''} 
					t = ax_mesh(t1,t2,1) 
					xc = t1.x 
					dc = (t1.d + t2.d)/2 
; construct full range spectrum 
					x = fltarr(1) & d = fltarr(1) 
					if tmp1.x(0) LT tmp2.x(0) then begin 
						xL = where(tmp1.x LT tmp2.x(0)) 
						x = [x,tmp1.x(xL)] & d = [d,tmp1.d(xL)] 
					endif else begin 
						xL = where(tmp2.x LT tmp1.x(0), count) 
						if count GT 0 then begin 
							x = [x,tmp2.x(xL)] & d = [d,tmp2.d(xL)] 
						endif 
					endelse 
					x = [x,xc] & x = x(1:n_elements(x)-1) 
					d = [d,dc] & d = d(1:n_elements(d)-1) 
					if tmp1.x(np1-1) GT tmp2.x(np2-1) then begin 
						xH = where(tmp1.x GT tmp2.x(np2-1)) 
						x = [x,tmp1.x(xH)] & d = [d,tmp1.d(xH)] 
					endif else begin 
						xH = where(tmp2.x GT tmp1.x(np1-1), count) 
						if count GT 0 then begin 
							x = [x,tmp2.x(xH)] & d = [d,tmp2.d(xH)] 
						endif 
					endelse 
; sort on x-values to order correctly in overlapping regions 
					xord = sort(x) 
					x = x(xord) 
					d = d(xord) 
					tmp = {t:'1d',d: d, x: x, xl: tmp1.xl, dn:d, dl: ''} 
				 END 
				else: BEGIN 
					print, ' append aborted' 
					return 
				ENDELSE 
			ENDCASE 
		ENDIF 
		tmp.dn = tmp.d 
		tmp.dl = tmp1.dl + ' AP ' + tmp2.dl 
		CurBuf = 0 
		HANDLE_VALUE, Data(CurBuf), tmp, /SET 
    	PlotBuf, CurBuf 
    ENDIF ELSE WIDGET_CONTROL, Uprompt, SET_VALUE='Append: only for spectra' 
ENDIF ELSE WIDGET_CONTROL, Uprompt, SET_VALUE='Append: only for spectra' 
END