; Copyright (c) 1998-2012 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	GET_NUM
;
;LAST CHANGED: ----------------------------------- 18-Aug-12
;
;PURPOSE:
;	This procedure is a widget that displays the current value
; of a parameter (if defined) and then allows user to input a replacement value
; A <cr> (enter) will retain the same value
;
;CATEGORY:
;	AXIS: utility (can run stand alone)
;
;CALLING SEQUENCE:
;	Result = GET_NUM(Prompt = prompt, Val = value, Title = Title, group = Axis_ID))
;
;CALLED FROM AXIS:
;  many places
;
;ROUTINES
;	NUM_EVENT, Event - event processing
;	GET_NUM - widget
;
;INPUTS: none
;
;KEYWORDS:
;   VAL = current (default) value
;   PROMPT = prompt to user
;	TITLE = title for widget
;	GROUP = Widget_Id of group leader (must be set to force modal; Axis_ID is name for axis_c)
;
;OUTPUTS:
;       The function returns a FLOAT value which is either :
;		the existing value (user hits <enter>)
;		or the first number in the string the user types
;
;COMMON BLOCKS:
;       TXTCOM (internal to get_num)
;
;SIDE EFFECTS:
;	A window is created/destroyed.
;
; DESCRIPTION:
;       This routine allows user to provide  a numerical value
;		If the top level group ID is supplied, the function widget is
;		put into modal mode (stays on top until user completes input; disables other functions of AXIS)
;
; EXAMPLES:
;       new_value = get_num(prompt='New value',val=current_value, group = axis_id)
;
; DEVELOPMENT NOTES:
;		should autosense if AXIS is the caller to avoid having to
;		explicitly provide the group ID
;
; MODIFICATION HISTORY:
; (20-jun-97 aph) first written
; (05-jun-98 aph) made function return a scalar NOT A 1-element array.
; (07-jun-99 aph) add separate prompt display; use IDL 5.2 modal convention; proper docs
; (27-feb-00 aph) AXIS standard documentation
; (09-sep-02 aph) format displayed number
; (01-Jun-08 aph) fix up documentation to be correct on 'val' and 'Axis_ID'
; (22-Nov-11 aph) add optional TITLE keyword; display '0' if the value is 0
; (18-Aug-12 aph) MAC IDL82 remove Dynamic_Resize
;-

PRO NUM_Event, Event
Common TXTCOM, text

WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev

CASE Ev OF
  'number': BEGIN
	   	 WIDGET_CONTROL, Event.Id, GET_VALUE = text
	   	 WIDGET_CONTROL, Event.Top, /DESTROY
     END
       ELSE: message, 'Invalid event call in Get_Num'
ENDCASE
END


FUNCTION get_num, GROUP=Group, VAL=val, Title = Title, PROMPT = prompt
Common TXTCOM, text

modal_val=1
IF N_ELEMENTS(Group) EQ 0 THEN begin
;  	test_valid = widget_event(AXIS, bad_id=bad_id) ;, FIND_BY_UNAME = 'AXIS')
;  	print, 'test_valid',test_valid
;	if group EQ 0 then				; attempt to auto-test if in AXIS - no go yet
group=0
modal_val=0
ENDIF

junk   = { CW_PDMENU_S, flags:0, name:'' }

if keyword_set(title) then gn_Title = title else  gn_Title = 'get_num'

NUM = WIDGET_BASE(GROUP_LEADER=Group, $
  ROW=2, $
  MAP=1, $
  modal = modal_val, $
  TITLE= gn_Title , $
  UVALUE='NUM')

prompt_text = 'input a number'
if keyword_set(prompt) then prompt_text = prompt

LABEL2 = WIDGET_LABEL( NUM, UVALUE='prompt',  VALUE=prompt_text)

num_text = ' '
;help, val
;print, 'val is ', val(0)
IF KEYWORD_SET(val) THEN begin
	if val(0) - fix(val(0)) NE 0 then begin
		num_text = strcompress(string(val(0),format='(G13.6)'))
	endif else num_text = strcompress(string(fix(val(0))))
	if val(0) EQ 0 then num_text = ' 0'
ENDIF
;print, 'length of string ', strlen(num_text)

if strlen(num_text) EQ 1 then num_text = ' 0'
;print, 'num_text = ', num_text

text = num_text

TEXT2 = WIDGET_TEXT( NUM,VALUE=num_text, $
  EDITABLE=1, $
  UVALUE='number', $
  YSIZE=1)

WIDGET_CONTROL, NUM, /REALIZE
WIDGET_CONTROL, TEXT2, /INPUT_FOCUS
XMANAGER, 'NUM', NUM

tval = float(strtrim(text(0),2))
val = float(0)
val = tval(0)
Return, val
END
