; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		EXTRAPOLATEAA.PRO
;
;LAST CHANGED: ----------------------------------- 	19-Jul-10
;
; PURPOSE:
;	This function projected spectra into whatever
; energy scale is requested by the X-SpecSim sub-program
;
; CATEGORY:
;	Utility; part of XSpecSim, spectral simulator package
;
; CALLING SEQUENCE:
;	Result = EXTRAPOLATEAA(EN)
;
; INPUTS: none
;	EN	= array of energies
;
; KEYWORDS: none
;
; OUTPUTS: none
;
;COMMON BLOCKS:
;	@XSpecSim_Com		X-SpecSim common block
;
;
; MODIFICATION HISTORY:
; (28-feb-07 jso) first version
; (18-Jul-10 aph) AXIS standard header added; XSpecSim_com added
;-

Function ExtrapolateAA, en
@XSpecSim_Com

AAmodData =  REPLICATE({Name:'alanine', Letter:'A', Formula:'', Energies:FLTARR(N_Elements(en)), Data:FLTARR(N_Elements(en))},N_ELEMENTS(aadata))
for i = 0, N_Elements(AAdata)-1 do begin
	AAModData[i].name = AAData[i].name
	AAModData[i].Letter=AAData[i].letter

	ans = fltarr(2,aadata[i].cSize)
	ans(0,*)=aadata[i].energies[0:aadata[i].cSize-1]
	ans(1,*)=aadata[i].data[0:aadata[i].cSize-1]
	AAModData[i].Data = interpol(ans(1,*),ans(0,*),en)
endfor
print, 'extrapolating'
return, 1
end