; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_XYSCL 
; 
;LAST CHANGED: ----------------------------------- 01-jan-00 
; 
;PURPOSE: 
;	This procedure sets the (x,y) scales of images 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	AX_XYSCL 
; 
;CALLED FROM AXIS: 
;	Images->Set XY scale 
 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;OUTPUTS: none 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; (xx-sep-97 aph) first wrote for Mephisto data 
; (14-jun-98 aph) axis_com 
; (08-jun-99 aph) add group keyword to get_num; fixed error ! 
; (01-jan-00 aph) AXIS standard documentation 
;- 
 
PRO ax_xyscl 
@axis_com
on_error,2 
 
HANDLE_VALUE, Data(CurBuf), tmp 
IF n_tags(tmp) EQ 0 THEN RETURN 
 if tmp.t EQ '2d' then begin         ; ONLY for images 
 	SetGraf, 'MainImg' 
	WIDGET_CONTROL, Uprompt, SET_VALUE='Set XY scale: select 1st point' 
	cursor, x1, y1, /data, /down 
	CurInd = DIndex(x1(0),y1(0),tmp) 
	CurX1 = CurInd(0) & CurY1 = CurInd(1) 
	Xd1 = tmp.x(curx1) & Yd1 = tmp.y(cury1) 
;		print, '1st point: ', x1(0), y1(0), ' in tmp', xd1, yd1 
	WIDGET_CONTROL, Uprompt, SET_VALUE='Set XY scale: select 2nd point' 
	cursor, x2, y2, /data, /down 
	CurInd = DIndex(x2(0),y2(0),tmp) 
	CurX2 = CurInd(0) & CurY2 = CurInd(1) 
	Xd2 = tmp.x(curx2) & Yd2 = tmp.y(cury2) 
;		print, '2nd point: ', x2(0), y2(0), ' in tmp', xd2, yd2 
	dist =sqrt((x2(0)- x1(0))*(x2(0)- x1(0)) + (y2(0) - y1(0))*(y2(0) - y1(0)) ) 
	dist_new = get_num(prompt='Distance (um)', group=axis_id) 
	slope = dist_new(0)/dist 
;		print, 'original, new, Slope = ', dist, dist_new(0), slope 
	tmp.x = slope*(tmp.x - x1(0)) 
	tmp.y = slope*(tmp.y - y1(0)) 
	CurBuf = 0 
	tmp.dl = 'scl ' + tmp.dl 
	HANDLE_VALUE, Data(CurBuf), tmp, /set 
	Label(CurBuf) = tmp.dl 
	PlotBuf,CurBuf 
	WIDGET_CONTROL, Uprompt, SET_VALUE='XY scale stretched by ' + string(slope) 
endif else WIDGET_CONTROL, Uprompt, SET_VALUE='XY-scale: only for images' 
END