; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	TEST
;
;LAST CHANGED: ----------------------------------- 07-Feb-16
;
;PURPOSE:
;	This reads an NSRCC PEEM stack from an NSRRC data file (extension: *,pem)
; and returns it as an aXis2000 format stack binary file (*.cb)
; with options to bin
;
;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = READ_NSRRC_PEEM(file, BIN=BIN, GROUP=GROUP, NOFILTER=nof, VERBOSE=VERBOSE, _extra=e )
;
;INPUTS:
;	FILE - NSRRC PEEM image or stack (multi-image) data file
;
;KEYWORD PARAMETERS:
;	FILE	 file name
;	GROUP	 name of group calling this program
;	NOFILTER - use *.* as filter
; 	VERBOSE - if set, print additional documentation
;	_EXTRA - pass on other call line parameters
;
; COMMON BLOCKS:
;   AXIS_COM 			set of common blocks for AXIS
;	BSIF_COMMON 		for output stack parameters
;	NSRRC_SPEM_COM   	parameters specific to NSRRC SPEM read-in
;	stack_process_com   for output stack parameters
;	VOLUME_DATA			output stack
;
;MODIFICATION HISTORY:
; (26-Aug-13 aph) first version (start from read_nsrrc_spem.pro (NSRRC SPEM)
; (07-Feb-16 aph) read info from the header
;-

function TEST, file=file, group=group, NOFILTER=nof, verbose = verbose,  _extra=e

on_error,2
@axis_com
@nsrrc_peem_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com

; ---- determine if aXis2000 is running (if so, assume this was called from it)
axis_on  = 0
if widget_info(axis_ID, /active) NE 0 then axis_on = 1		; this works even if axis_ID is undefined

; information from Gung Chiang <gcyin@nsrrc.org.tw> on NSRRC PEEM format
; -------------
; single LARGE file:   *.pem
; [PEEM_HEADER]   (header, size of 39920 bytes at 32 bit system)
; [BODY]  	  	   (Energy stacks)*pixel_num*sizeof(unsigned short) (2 8-bit bytes for each element)
; ------------------
;  by trial and error I found, skip a byte array 39920 long then read each image as a 16-bit integer array of
;  size nx * ny
;

; in the header file , there is the following   [ from email of 1 Sep 2013 )
;  Position
;: Offset is unsigned int ->  8    F09B0000=>39920 (high bytes at back) // total bytes from the beginning of file to the Data
; image number->12                E2000000=>226 images
; nx->16                                   9202=>658
; ny->18                                   0502=>517
;

; ----------------------------------------------

if n_elements(file) eq 0 then begin  ;popup file dialog box
   filter ='*.pem'
   if keyword_set(nof) then filter='*'
   file=PICKFILE2(/Read, FILTER=filter, /LPATH, DEFPATH=defpath)
endif

s = 0
IF strlen(file) LE 0 THEN return, s

; ------- SHOULD READ USING IDL's binary file reader

; file has an ascii text header, "PEEM3D" - is that part of the 39920 byte header ?
; see what can be read using guesses
;check = 'Yes'
;a = 0. ; '                      '
;while check eq 'Yes' do begin
;	readu, unit, a
;	print, a
;	check = dialog_message(/question, 'Continue ? (default = Yes)')
;endwhile
; POINT_LUN, unit, 0	; return file to start

; ----------- read number of images and nx, ny from first header (NB each image has an associated header)
openr,unit,file,/get_lun
a=strarr(8)
t=' '
for i = 0, 7 do begin
   readu, unit, t
   a(i) = t
endfor
print, a(0:5)
offset = ulong(1)
readu, unit, offset
print, 'offset = ', offset
n_imgs=ulong(1)
readu, unit, n_imgs
print, '# of images = ', n_imgs
nx = uint(1) & ny = uint(1)
readu, unit, nx
print, 'nx = ', nx
readu, unit, ny
print, 'ny = ', ny
close, unit, /all		; start again
free_lun, unit
return, a
end