; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	IMG_ASAV 
; 
;LAST CHANGED: ----------------------------------- 15-apr-00 
; 
;PURPOSE: 
;	This procedure saves shift and stretch parameters in user-defined 
; files at the end of IMAG_ALIGN 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	IMG_ASAV, one_pt=one_pt 
; 
;CALLED FROM AXIS: 
;	->Stacks->image align -> {shift, stretch-shift} 
; 
;ROUTINES 
;	if the file contains multiple PROs 
; list these here, along with a brief description of their function 
; 
;INPUTS: via common 
; 
;KEYWORDS: 
;	one-pt - defines shift only 
; 
;OUTPUTS: 
; files for shifts (2 or 4); stretch factors are writen to disk 
; Filenames (*.sl) and SHIFT data (*.al) files 
; Buffer Contents	filename 
;	5		X1		*.aX1 
;	6		Y1      *.aY1 
; 	8		X2      *.aX2 
;	9 		Y2      *.aY2 
;	4 		stretch factor (regenerate independent (X,Y) from files/buffers 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; ( 7-jun-98 aph) extracted from "Image_Process.Image alignment.save shifts" 
; (14-jun-98 aph) axis_com 
; ( 7-jul-99 aph) FREE_LUN as well as close ! 
; (15-apr-00 aph) AXIS standard documentation 
;- 
 
PRO img_asav, one_pt=one_pt 
 
@axis_com
on_error,2 
 
  file = pickfile2(/write,FILTER='*.a*',/LPATH, DEFPATH=defpath) 
  HANDLE_VALUE, Data(5), tmp              ; get x1 positions 
  IF n_tags(tmp) NE 0 THEN BEGIN 
     low=0 
   	 if tmp.x(1) EQ tmp.x(0)+0.001 then low = 1   ; remove 1st marker point if there 
 	 file = strmid(file,0,strpos(file,'.'))+'.aX1' 
  	 openw,unit, file,/get_lun 
	 for i = low,n_elements(tmp.x)-1 do printf,unit, strcompress(tmp.x(i)),' ',strcompress(tmp.d(i)) 
	 close,unit & free_lun, unit 
	 print, 'X1 values written to: ',file 
  ENDIF 
  HANDLE_VALUE, Data(6), tmp              ; get y1 positions 
     IF n_tags(tmp) NE 0 THEN BEGIN 
   		low=0 
   	 	if tmp.x(1) EQ tmp.x(0)+0.001 then low = 1   ; remove 1st marker point if there 
  	 	file = strmid(file,0,strpos(file,'.'))+'.aY1' 
  	 	openw,unit, file,/get_lun 
	 	for i = low,n_elements(tmp.x)-1 do printf,unit, strcompress(tmp.x(i)),' ',strcompress(tmp.d(i)) 
	 	close,unit  & free_lun, unit 
	 print, 'Y1 values written to: ',file 
   	 endif 
 
if NOT keyword_set(one_pt) THEN BEGIN                      ; save stretch factors 
  HANDLE_VALUE, Data(8), tmp              ; get x2 positions 
   IF n_tags(tmp) NE 0 THEN BEGIN 
     low=0 
   	 if tmp.x(1) EQ tmp.x(0)+0.001 then low = 1   ; remove 1st marker point if there 
   	 file = strmid(file,0,strpos(file,'.'))+'.aX2' 
  	 openw,unit, file,/get_lun 
	 for i = low,n_elements(tmp.x)-1 do printf,unit, strcompress(tmp.x(i)),' ',strcompress(tmp.d(i)) 
	 close,unit  & free_lun, unit 
	 print, 'X2 values written to: ',file 
  ENDIF 
  HANDLE_VALUE, Data(9), tmp              ; get y2 positions 
  IF n_tags(tmp) NE 0 THEN BEGIN 
    low=0 
   	if tmp.x(1) EQ tmp.x(0)+0.001 then low = 1   ; remove 1st marker point if there 
 	file = strmid(file,0,strpos(file,'.'))+'.aY2' 
  	openw,unit, file,/get_lun 
 	for i = low,n_elements(tmp.x)-1 do printf,unit, strcompress(tmp.x(i)),' ',strcompress(tmp.d(i)) 
	close,unit  & free_lun, unit 
	print, 'Y2 values written to: ',file 
  endif 
 
endif 
; save list of filenames for stack_movie or stack_analyze 
	filenm = strmid(file,0,strpos(file,'.'))+'.sl' 
	openw,unit, filenm,/get_lun 
	HANDLE_VALUE, Data(10), f_store 
	for i = 0,f_store.n(0)-1 do begin 
  	printf,unit, strcompress(f_store.f(i)) 
  	endfor 
  	close,unit  & free_lun, unit 
 
  	if !version.os_family EQ 'unix' then sep = '/' else sep = '\' 
  	file=strmid(file,rstrpos(file,sep)+1,strlen(file)) 
  	file = strmid(file,0,strpos(file,'.'))+'.a*' 
	filenm=strmid(filenm,rstrpos(filenm,sep)+1,strlen(filenm)) 
	WIDGET_CONTROL, Uprompt, SET_VALUE='shifts: ' + file + ' names:' + filenm 
 
 END