; Copyright (c) 1998-2014 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_CLEAR
;
;LAST CHANGED: ----------------------------------- 22-Jul-14 (aph)
;
; PURPOSE:
;	This procedure clears one or more AXIS buffers.
; It is also used to display the AXIS logo on startup or an all-clear call
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	AX_CLEAR [, all=all, select=select, current = current, spin=spin]
;
;CALLED FROM AXIS:
;	->Utilities->Clear->{current,selected,all}

;INPUTS: none
;
;KEYWORDS:
;	ALL - clear all buffers and display logo
;	SELECT - clear user-selected buffers
;	CURRENT - clear current buffer only
;	SPIN - use rotating logo (actually triggered from AxSpin flag in axis_com)
;
;OUTPUTS: none
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (19-sep-99 aph) isolated from aaa_axis to use elsewhere (img_aln)
; (26-sep-99 aph) fix logic to execute only 1 of the 3 choices
; (28-sep-99 aph) make clear,/all work correctly
; (30-oct-99 aph) set background to white
; (16-nov-99 aph) introduce WIDGET_CONTROL, CLEAR_events to dump mouse clicks
; (31-dec-99 aph) AXIS standard documentation
; (29-jan-00 aph) rotating logo
; (20-feb-00 aph) correct color for logo if >256 colors
; (05-dec-00 cgz) added in platform context for logo directory
; (19-dec-00 cgz) modified ax_black_color_index to ax_plot_bkgd_color_index
; (29-dec-00 aph) get to work properly with zoom~thumbnails
; (20-aug-01 aph) add group call to mbuf for modal action
; (22-aug-01 aph) rescue rotating logo
; (31-dec-01 aph) delete buffer 0 if all_clear; introduce ax_clear_oneworld, ax_clear_allworld
; (14-may-02 aph) change to png
; (08-jul-02 aph) switch depending on IDL version
; (21-feb-10 aph) remove 'help, tmp'; use logo_R,_G,_B to set colors (problem of white)
; (21-Jun-10 aph)  ad ax_color, /no_load call at end to re-establish default color table
; (16-Jun-14 aph) recover if logo_file cannot be  found (e.g. if the CodePath is wrong)
; (22-Jul-14 aph) return if called without aXis2000 running
;-

PRO ax_clear_oneworld
; ------------------------ display random logo file
@axis_com
on_error,2
SetGraf, 'MainImg'
nfile = randomu(systime)*36
CASE strupcase(!version.os_family) OF
	'VMS' : BEGIN
		logo_file = CodePath +'logo:logoxxx.png'
	END
	'WINDOWS' : BEGIN
		logo_file = CodePath +'logo\logoxxx.png'
	END
	'MACOS' : BEGIN
		logo_file = CodePath +'logo:logoxxx.png'
	END
	'UNIX' : BEGIN
		logo_file = CodePath +'logo/logoxxx.png'
	END
	ELSE : BEGIN
		print,'Unrecognized operating system'
	END
ENDCASE
; print,'logo_file : ',logo_file
xxx_pos = strpos(logo_file,'xxx')
ts = strmid(strcompress(string(1000 + nfile)),2,4)
strput,logo_file,ts, xxx_pos
test = float(!version.release)
if test LT 5.3 then rot_val = 7 else rot_val = 8	; SGU changed from 7 to 8 to accomodate changes

; check if logo_file exists; if not ask user to find it
if file_test(logo_file) EQ 0 then begin
	axis_log, 'Cannot find logo file - perhaps code directory incorrect ? '
	logo_file = pickfile2(Title='Please select a logo file ')
	if n_elements(logo_file) EQ 0 then return
endif
tmp = rotate(read_png(logo_file,R,G,B),rot_val)

;help, tmp

logo_R = R & logo_G = G  & logo_B = B

if n_elements(tmp) GT 1 then begin
  main = 360.*gr_scale
  tmp = congrid(tmp, main, main)
  TVLCT, logo_R, logo_G, logo_B
  TV, tmp
endif
END

; *******************************************************************

PRO ax_clear_allworld
; ------ display rotating logo --------
@axis_com
on_error,2
SetGraf, 'MainImg'
ax_load_logo,/axis
wset, ColorbarPlot
erase, ax_plot_bkgd_color_index	;ax_black_color_index
logo_rate = 0.2
wset, MainImg
TVLCT, logo_R, logo_G, logo_B
Widget_control, AXIS_ID, timer = logo_rate
DEVICE, COPY =[0, 0, logo_size, logo_size, 0, 0, logo_win(logo_now)]
empty
END

; *******************************************************************

PRO ax_clear, all=all, select=select, current = current, spin = spin

@axis_com
on_error,2

if n_elements(aXis_ID) GT 0 and aXis_ID EQ 0 then return

; erase the windows
	SetGraf, 'XZPlot'  & erase
	SetGraf, 'YZPlot'  & erase
	SetGraf, 'MainImg' & erase
IF Thumb_plot EQ 1 then CurBuf=1

close,/all

;!p.background = ax_white_color_index ; force background to white
WIDGET_CONTROL, /CLEAR_events

if keyword_set(all) then begin
   For i = 0, 9 DO BEGIN
		HANDLE_VALUE, Data(i), 0, /set
		Label(i) = 'empty'
	EndFor
  Label(0) = 'working buffer'
  for i = 0, 9 do begin
  	Label(i)='empty'
  	BufStat(i) = 0
  endfor
  ThumbLbls, /all     ; redsplays all thumbs etc
  ax_color
  CurBuf = 1
  PlotBuf,CurBuf
  first_plot = 1			; set switch to auto-convert color tables to AX_COLOR on next round
  BufStat(CurBuf) = 1   ; indicate buffer 1 is active
  WIDGET_CONTROL, Bad_ID = BadID, BufButs, SET_VALUE = BufStat
  text =  string(format='("Welcome to AXIS.",/,"Version ",A)',axis_ver)
  WIDGET_CONTROL, Bad_ID = BadID,Uprompt, SET_VALUE= text
  wset, MainImg		; Display Logo
  tmp = 0
  if AxSpin EQ 1 then ax_clear_allworld else ax_clear_oneworld
  return
ENDIF

IF keyword_set(select) then begin
	bt = Mbuf(group = axis_ID)        ; get multi-buffer list
	IF bt(0) NE -1 then begin 		; cancel
		nb = n_elements(bt)
		FOR i = 0, nb-1 DO BEGIN
			HANDLE_VALUE, Data(bt(i)), 0, /set
			Label(bt(i)) = 'empty'
			Blbl_upd & ThumbPlot, bt(i)
		EndFor
		if nb EQ 10 then begin
			  if AxSpin EQ 1 then ax_clear_allworld else ax_clear_oneworld
		endif else begin
			TVLCT, UserR, UserB, UserG	; load current user-defined color table
		  	ax_color			; set standard axis color scheme
			PlotBuf,CurBuf
			WIDGET_CONTROL,Bad_ID = BadID, Uprompt,  Set_Value = ''
		endelse
	ENDIF
ENDIF

IF keyword_set(current) then begin
  HANDLE_VALUE, Data(CurBuf), 0, /set
  TVLCT, UserR, UserB, UserG	; load current user-defined color table
  ax_color			; set standard axis color scheme
  Label(CurBuf) = 'empty'
  PlotBuf,CurBuf
  WIDGET_CONTROL, Bad_ID = BadID, Uprompt,  Set_Value = ''
ENDIF

IF Thumb_plot EQ 1 then begin
	ThumbLbls, /all
	for i = 1, 9 do begin
	   BufStat(i) = 0
	endfor
	BufStat(CurBuf) = 1
ENDIF

ax_color, /noload

END

