; Copyright (c) 1998-2003 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_PAR_SAVE
;
;LAST CHANGED: ----------------------------------- 04-jun-03
;
;PURPOSE:
;	This procedure writes path, and file names of reference spectra used in
; stack  (ax_svd, stack_fit, cgo_fit), line (line_fit) and spectra ( ax_curvefit) fitting procedures
;
;CATEGORY:
;	STAND ALONE: utility
;
;CALLING SEQUENCE:
;	AX_PAR_SAVE,par_file, ncomp, comp_names, comp_files
;
;CALLED FROM AXIS:
;	stacks~maps~(ax_svd, stack_fit, cgo_fit); linescans~line fit; spectra~curve fit

;INPUTS:
;	PAR_FILE	parameter file name
;	NCOMP	number of components
;	COMP_NAMES - (ncomp) 1-d array of fit names
;	COMP_FILES - (ncomp) 1-d array of files
;
;KEYWORDS: none
;
;OUTPUTS:
;	none
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
;	Path is determined from comp_names
;
;MODIFICATION HISTORY:
; (04-jun-03) first developed from duplicates in stack fitting routines
;-
PRO ax_par_save, par_file, ncomp, comp_names, comp_files
@axis_com
on_error,2

; check information is consistent
tn = size(comp_names)
tf = size(comp_files)
if tn(1) NE ncomp OR tf(1) NE ncomp then begin
	print, 'AX_PAR_SAVE:  number of names or files not same as number of components'
	return
endif

; - determine path - require all reference files in same folder

tn = ax_name(comp_files(0))
par_path = tn(0)

openw, iunit, par_file, /get_lun
printf, iunit, ncomp
printf, iunit, par_path
for i = 0,ncomp-1 do begin
	printf, iunit, comp_names(i)
	tn = ax_name(comp_files(i))
	printf, iunit, tn(1) + '.' + tn(2)
endfor
close, iunit   &   free_lun, iunit
print, 'reference spectra parameters saved to ', par_file

END
