; Copyright (c) 1994-2014 ER. JDD, A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SPLOT.PRO
;
;LAST CHANGED: ----------------------------------- 	21 Jul 2014
;
; PURPOSE:
;	This procedure plots a 1D spectral structure in an ID window
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
; for procedures:
;	splot, s, [O=oplot, DN=dn, WB=wb, CHARSIZE=csz, COLOR=clr, ZERO=zero,  _extra=e]
;
; INPUTS:
;		s	1D structure
;
; KEYWORDS:
;	O			overplot
;	DN			normalization array (Io)
;	WB			white on black
;	CHARSIZE	characteri size
;	COLOR		line color
;	ZERO		autoscale y from 0
;	 _extra		pass along PLOT options
;
; OUTPUTS:
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;;
; MODIFICATION HISTORY:
; (19-Feb-96 jdd) initial creation
; (15-Jun-16 jdd) added generalized interpretation of structures
;        in SPLOT, SPLOT2D, SPLOT3D
;         separated splot stuff from graph.pro
; (29-06-96 aph) allow numerical limts on ranges
; (06-Dec-97 aph) remove print of ytitle
; (03-jan-99 aph) add back in YTitle (!!)
; (24-jun-99 aph) consistent image/spectra color tables
; (13-aug-99 aph) no change - just using debugs to track reform problem
; (14-nov-00 cgz) migrated from SPLOTA.PRO
; (22-Mar-06 aph) increase character size
; (21-Jul-14 aph) AXIS standard header added
;-

pro splot, s, O=oplot, DN=dn, WB=wb, CHARSIZE=csz, COLOR=clr, $
    ZERO=zero,  _extra=e
;--------------------------------------
; basic 1-D structure {d:data, x:xaxis}
; optional label fields{ dl:, xl:} fields for xaxis and data label
; optional field is {dn:} for data normalization
; options:  /O -- overplot
;           O=iclr -- overplot with color=iclr

@axis_com
on_error,2

yst=16
if keyword_set(zero) then yst=0
; if keyword_set(e) then print,e   ;aph - deleted printing of extra opts
zdata=s.d
if keyword_set(dn) then zdata=s.dn
iclr=[0,255]	; default to Black-on-White
if keyword_set(wb) then iclr=[255,0]
if keyword_set(clr) then iclr(0)=clr

if keyword_set(oplot) then begin
   if not keyword_set(clr) then iclr(0)=128
   if oplot gt 1 then iclr(0)=oplot
   oplot, s.x, zdata, color=iclr(0), _extra=e
endif else begin
   if not keyword_set(csz) then csz=1.5	;nominal character size
   if not keyword_set(clr) then clr=0
   xl='' & yl = '' & dl=''
   if stag(s,'xl') then xl=s.xl
   if stag(s,'yl') then yl=s.yl
   if stag(s,'dl') then dl=s.dl
   plot, s.x, zdata, $
      xtitle=xl, xstyle=1, ystyle=yst, title=dl, ytitle = yl, $
      color=iclr(0), back=iclr(1), charsize=csz, _extra=e
endelse
end

