; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AXIS_START.PRO 
; 
;LAST CHANGED: ----------------------------------- 20-May-00 
; 
;PURPOSE: 
;	This set of procedures is a widget to guide IDL start-up 
; 
;CATEGORY: 
;	STAND ALONE: utility 
; 
;CALLING SEQUENCE: 
;	AXIS_START 
; 
;ROUTINES 
;	AXIS_START_BASE_event, event 
;	AXIS_START_BASE, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_ 
;	AXIS_start, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_ 
; 
;INPUTS: none 
; 
;KEYWORDS: none 
; 
;COMMON BLOCKS: none 
; 
;MODIFICATION HISTORY: 
; Generated on:	09/26/99 11:48.55 
; (5-nov-99 aph) larger zimba button 
; (20-may-00 aph) AXIS standard documentation 
;- 
; 
pro AXIS_START_BASE_event, Event 
 
;common AXIS_START, AXIS_START_BASE 
 
  wWidget =  Event.top 
 
  case Event.id of 
 
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_AXIS'): begin 
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $ 
        BUT_AXIS, Event 
    end 
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_ZimbaStack'): begin 
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $ 
        BUT_ZimbaStack, Event 
    end 
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_IDL'): begin 
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $ 
        BUT_IDL, Event 
    end 
    else: 
  endcase 
 
end 
 
pro AXIS_START_BASE, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_ 
 
;common AXIS_START, AXIS_START_BASE 
 
  Resolve_Routine, 'AXIS_start_eventcb'     ; Load event callback routines 
 
  AXIS_START_BASE = Widget_Base( GROUP_LEADER=wGroup, UNAME='AXIS_START_BASE'  $ 
      ,SCR_XSIZE=300 ,SCR_YSIZE=81 ,TITLE='IDL' ,SPACE=3 ,XPAD=3  $ 
      ,YPAD=3) 
 
 
  BUT_AXIS = Widget_Button(AXIS_START_BASE, UNAME='BUT_AXIS' ,XOFFSET=9  $ 
      ,YOFFSET=10 ,SCR_XSIZE=50 ,SCR_YSIZE=30 ,/ALIGN_CENTER  $ 
      ,VALUE='AXIS') 
 
 
  BUT_ZimbaStack = Widget_Button(AXIS_START_BASE, UNAME='BUT_ZimbaStack'  $ 
      ,XOFFSET=71 ,YOFFSET=10 ,SCR_XSIZE=150 ,SCR_YSIZE=30  $ 
      ,/ALIGN_CENTER ,VALUE='Zimba Stack_Analyze') 
 
 
  BUT_IDL = Widget_Button(AXIS_START_BASE, UNAME='BUT_IDL' ,XOFFSET=230  $ 
      ,YOFFSET=10 ,SCR_XSIZE=50 ,SCR_YSIZE=30 ,/ALIGN_CENTER  $ 
      ,VALUE='IDL') 
 
  Widget_Control, /REALIZE, AXIS_START_BASE 
 
  XManager, 'AXIS_START_BASE', AXIS_START_BASE 
 
end 
; 
; Empty stub procedure used for autoloading. 
; 
pro AXIS_start, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_ 
  AXIS_START_BASE, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_ 
 
;common AXIS_START, AXIS_START_BASE 
 
end 
