; Copyright (c) 2007 A. Scholl  All rights reserved
;+
;NAME:
;		READ_P3B_SPECTRUM
;
;LAST CHANGED: ----------------------------------- 	20-Jan-07
;
; PURPOSE:
;	This function reads a ALS PEEM3 spectrum
;
; CATEGORY:
;	utility
;
; CALLING SEQUENCE:
;	Result =  Read_P3B_spectrum, file=file
;
; INPUTS: only by keyword
;
; KEYWORDS:
;	File	name of file (ext = '*.dat')
;	FLTR 	alternative data filter
;	SILENT	do not give log details
;
; OUTPUTS:
;	RESULT	1-d axis structure
;
; COMMON BLOCKS:
; @axis.com
;
;
; MODIFICATION HISTORY:
; (20-Jan-07 aph) first written
;-

function Read_P3B_spectrum, file=file, silent = silent, fltr=fltr
@axis_com
@bsif_com
on_error,2


IF NOT keyword_set(file) then begin
	if not keyword_Set(fltr) then fltr='*.dat'
	file = pickfile2(/READ, FILTER=fltr, TITLE='ALS PEEM3 spectrum', /LPATH, DEFPATH=defpath)
ENDIF

s = ''

if file EQ '' THEN RETURN, s  ; bail-out if no filename
check = findfile(file)		 ; bail-out if non-existent file
if strlen(check(0)) EQ 0 then begin
	axis_log, 'Cannot find ' + file
	return, s
endif

openr, iunit, file, /get_lun
i=0
tmp = fltarr(2)
energy = fltarr(1)
intensity = fltarr(1)
while not EOF(iunit) do begin
	readf, iunit, tmp
	energy(i)= tmp(0)
	intensity(i) = tmp(1)
	energy = [energy, 0.0]
	intensity = [intensity, 0.0]
	i = i +1
endwhile
close, iunit
free_lun, iunit
energy = energy[0:n_elements(energy)-2]
intensity = intensity[0:n_elements(intensity)-2]
t = ax_name(file)
dl =  t(1)
s = {t:'1d', x:energy, d:intensity, dn:intensity, xl:'E (eV)', dl: dl}
if not keyword_set(silent) then $
   axis_log, strcompress(string(i-1)) + ' pt spectrum:   ' + dl

return, s
end