;+
;NAME:
;	TEXT_READ1.PRO
;
;LAST CHANGED: ----------------------------------- 21-Apr-14
;
;PURPOSE:
;	TEXT_READ1 - simple text file read-in (single block)
;
;CATEGORY:
;	STAND ALONE: utilities
;
;CALLING SEQUENCE:
;	Result = text_READ1(FILNENAME)
;
;CALLED FROM AXIS:
;	many procedures
;
;ROUTINES
;	function 	TEXT_READ1, FNAME, print=print
; reads simple text files consisting of 1 block plus a header
; KEYWORDS
;	PRINT - if set, then print header information
;
;COMMON BLOCKS: none
;
;-----------------
; FILE ROUTINES -- eli's text format
;-----------------
;file structure-
;line 0: number of items
;line 1: string=name of first item
;line 2: size(item)
;line 3: item, space-delimited
;line 4: string=name of next item
;    :
;    :
;
;MODIFICATION HISTORY:
; (25-may-99 aph) activated print option in textread1 to work with ascii read-in
; (26-feb-00 aph) AXIS standard documentation
; (11-nov-00 cgz) migrated from former FILE.PRO
; (21-Apr-14 aph) tried to desensitize to  not-number characters at the end-of-file
;                 but failed. Should probably modify parsestring.pro to deal with those
;-
; *******************************************************************************

function text_read1,fname, PRINT=print
   ;reads simple files which only consist of header info and one block
   on_error,2
   s=''
   openr,unit,fname,/get_lun
   while not eof(unit) do begin
      readf,unit,s
      fa=parsestring(s) & sfa=size(fa)
      if keyword_set(print) and sfa(0) EQ 0 then print, s
      if sfa(0) gt 0 then begin
        ;line contains numbers
		nrows=6000
        ans=fltarr(sfa(1), nrows)
        ans(*,0)=fa
        j=long(1)
        while not eof(unit) do begin
           ;if j/100 eq j/100. then print,j
           readf,unit,fa
           ans(*,j)=fa
           j=j+1
;           help, fa		; attempt to desensitize - fa for the ref-spectra\aniline-solomon-END.txt
;			t=size(fa)      ; still has a numerical value, even though there is a non-ascii character as well
;           if t(0) gt 0 then begin
;         		ans(*,j)=fa
;        		j=j+1
;        	endif
        endwhile
      endif
   endwhile
   close,unit
   free_lun,unit
   return,ans(*,0:j-1)
end


