; Copyright (c) 1998-2005 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_IMAGE_ADD
;
;LAST CHANGED:-------------------------- 13-oct-05
;
;PURPOSE
;  This procedure adds the currently displayed image
;  to a user-selected second image with a user-selected scale factor.
;  A negative scale factor subtracts the second image from the first.
;  The common (x,y) region is interpolated to the mesh of
;  the more finely sampled image.
;
;CATEGORY:
;	AXIS: image analysis
;
;CALLING SEQUENCE:
; 	ax_img_add
;
;INPUT: none (uses AXIS_COM common blocks for input/output)
;
;KEYWORDS: none
;
;OUTPUT:
;	(Image in buffer_9) = (1st_image) + (scale_factor)*(2nd_image)
;
;COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (28-dec-99 aph) isolated from AXIS_C
; (31-dec-99 aph) AXIS standard documentation
; (23-feb-00 aph) add groupID to buffer call (avoid modal error)
; (14-Oct-05 aph) fix sum/ratio error from McNeil
;-

PRO AX_IMAGE_ADD
@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t EQ '2d' then begin
    bt = buffer(group = AXIS_ID)
    IF bt EQ -1 THEN RETURN				  ; abort procedure if no other image selectred
  	HANDLE_VALUE, Data(bt), div
  	IF n_tags(div) EQ 0 THEN RETURN
	IF (div.t EQ '2d') THEN BEGIN     ; for images only
		t = 1
		tmp_step = tmp.x(1) - tmp.x(0)		; do not mesh if they are the same step size
		div_step = div.x(1) - div.x(0)
		del = 0.001*tmp_step
		IF abs(tmp_step - div_step) GT del then begin
  			t = Ax_Mesh(tmp,div,2)    ; modified to  match (x,y) scales
			axis_log,'step sizes of images differ - interpolating to common mesh'
		ENDIF
  		IF t NE 0 then BEGIN
	 	   	Cnst = get_num(val = factor(0), prompt='scaled by?', group=axis_ID)
		   	factor(0) = cnst
		   	tmp.d = tmp.d + cnst(0)*div.d
     	   	CurBuf = 0
 	   		tmp.dl = string(format='(A," +",G10.2," ",A)',tmp.dl,cnst,div.dl)
   	   		HANDLE_VALUE, Data(CurBuf), tmp, /set
   	   		Label(CurBuf) = tmp.dl
   	   		PlotBuf,CurBuf
 		ENDIF ELSE axis_log, 'Image addition: incompatible buffers'
   	 ENDIF ELSE axis_log, 'Add buffers: only for 2 images'
ENDIF ELSE axis_log, 'Add buffers: only for images'
END
