; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	XM1_LOAD
;
;LAST CHANGED: ----------------------------------- 21-feb-01
;
;PURPOSE:
;	This function reads in XM-1 images from *.spe files
;
;CATEGORY:
;	images read in
;
;CALLING SEQUENCE:
;	Result = XM1_LOAD(file=file, _extra=e)
;
;CALLED FROM AXIS:
;	Read->Images->ALS-XM1
;
;INPUTS: none. All input parameters are passed as keywords.
;
;KEYWORDS:
;	FILE 	filename to read
;	NOF		no filter
;	GROUP 	name of parent group (Axis_ID)
;	_EXTRA	passed on parameters
;
;OUTPUTS:
;	RESULT = AXIS 2d structure
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;PROCEDURE:
;	XM1_LOAD uses xmload, nojunk,loadcmsa, flatbg (from Greg Denbaux)
;
;MODIFICATION HISTORY:
; (21-feb=01 aph) first version
;-

Function xm1_load, nof = nof, file=file, group = group, _extra=e
@axis_com
on_error,2

IF NOT keyword_set(file) then begin
	fltr='*.spe'
	if keyword_set(nof) then fltr='*'
	if keyword_set(group) then $
		file = pickfile2(/READ, FILTER=fltr, /LPATH, DEFPATH=defpath) $
	else  file = dialog_pickfile(Title='select XM-1 image file', FILTER=fltr)
ENDIF
s = ''
if file EQ '' THEN RETURN, s  ; bail-out if no filename
check = findfile(file)		 ; bail-out if non-existent file
if strlen(check(0)) EQ 0 then begin
	text =  'Cannot find ' + file
	print, text
	if keyword_set(group) then $
		widget_control, Bad_ID=Bad_ID, Uprompt, SET_VALUE=text
	return, s
endif

a = xmload(file, /noshow)
a_size = size(a)
nx = a_size(1) &  ny = a_size(2)
x = findgen(nx)
y = findgen(ny)
energy = 0. & dwell = 0.
text = string(format= $
  '(i4," x",i4," image read from ",A,". E =",f7.2," eV. Dwell =",f5.2," ms.")', $
   nx, ny, file, energy, dwell)
xl = string(FORMAT='("x (um)     E = ",f8.3," eV     dwell = ",f7.2," ms")', $
      energy, dwell)
t = ax_name(file) & fileshort = t(1)
print, text
s = {t:'2d', x:x, y:y, d:a, e: energy, xl:xl, yl:' ', dl: fileshort}	; add E
return, s
end